package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;

public class OrderDetail implements DomainObject {

    public OrderDetail(String orderNo, int recordNo, CartItem cart, Item item, User user, AoSetting aoSetting, Map<String, Object> userForm) {

        this.orderNo = orderNo;
        this.recordNo = recordNo;

        this.userCd = user.getUserCd();

        this.itemCd = item.getItemCd();
        this.itemName1 = item.getItemName1();
        this.itemName2 = item.getItemName2();

        this.userItemCd = item.getUserItemCd();
        this.userItemName1 = item.getUserItemName1();
        this.userItemName2 = item.getUserItemName2();
        this.quantityPerCase = StringUtil.defaultString( item.getQuantityPerCase(), "0.0");

		this.unit = item.getUnit();

        this.orderCaseQuantity = StringUtil.defaultString( cart.getOrderCaseQuantityFormat(aoSetting), "0.0");
        this.shipmentCaseQuantity = StringUtil.defaultString( CartItem.getOrderCaseQuantityFormat( new BigDecimal(0.0), aoSetting), "0.0");
        this.unshippedCaseQuantity = StringUtil.defaultString(cart.getOrderCaseQuantityFormat(aoSetting), "0.0");
        this.orderQuantity = StringUtil.defaultString(cart.getOrderQuantityFormat(aoSetting), "0.0");
        this.shipmentQuantity = StringUtil.defaultString( CartItem.getOrderQuantityFormat( new BigDecimal(0.0), aoSetting), "0.0");
        this.unshippedQuantity = StringUtil.defaultString(cart.getOrderQuantityFormat(aoSetting), "0.0");
        this.wholesalePrice = StringUtil.defaultString(cart.getWholeSalePriceFormat(aoSetting, userForm), "0.0");
        this.retailPrice = StringUtil.defaultString(cart.getRetailPriceFormat(aoSetting, userForm), "0.0");

        this.taxBracketCd = item.getTaxBracketCd();
        this.taxExemptDiv = item.getTaxExemptDiv();
        this.taxPrice = StringUtil.defaultString(cart.getTaxPrice(), "0.0");
        this.taxRate = cart.getTaxRate();

        this.taxDiv = user.getTaxDiv();
        this.taxCalcDiv = user.getTaxCalcDiv();
        this.taxFractionDigitDiv = user.getTaxFractionDigitDiv();
        this.taxFractionDiv = user.getTaxFractionDiv();

        // TODO フラグ類
        this.shipmentEndFlg = Integer.parseInt(ShipmentEndFlg.NO);
        this.aoFlg = Integer.parseInt(AoFlg.NO);
        this.cancelFlg = Integer.parseInt(CancelFlg.NO);
        this.shipmentCompDiv = Integer.parseInt(ShipmentCompDiv.NO);

    }

    public OrderDetail(String orderNo, int recordNo, Map<String, Object> detail, Item item, User user, AoSetting aoSetting, Map<String, Object> userForm) {
        this.orderNo = orderNo;
        this.recordNo = recordNo;

        this.userCd = user.getUserCd();

        this.itemCd = item.getItemCd();
        this.itemName1 = item.getItemName1();
        this.itemName2 = item.getItemName2();

        this.userItemCd = item.getUserItemCd();
        this.userItemName1 = item.getUserItemName1();
        this.userItemName2 = item.getUserItemName2();
        this.quantityPerCase = StringUtil.defaultString(item.getQuantityPerCase(), "0.0");

        this.orderCaseQuantity = StringUtil.defaultString(CartItem.getOrderCaseQuantityFormat(aoSetting, detail), "0.0");
        this.shipmentCaseQuantity = StringUtil.defaultString(CartItem.getOrderCaseQuantityFormat( new BigDecimal(0.0), aoSetting), "0.0");
        this.unshippedCaseQuantity = StringUtil.defaultString(CartItem.getOrderCaseQuantityFormat(aoSetting, detail), "0.0");
        this.orderQuantity = StringUtil.defaultString(CartItem.getOrderQuantityFormat(aoSetting, detail), "0.0");
        this.shipmentQuantity = StringUtil.defaultString(CartItem.getOrderQuantityFormat( new BigDecimal(0.0), aoSetting), "0.0");
        this.unshippedQuantity = StringUtil.defaultString(CartItem.getOrderQuantityFormat(aoSetting, detail), "0.0");
        this.wholesalePrice = StringUtil.defaultString(CartItem.getWholeSalePriceFormat(aoSetting, detail, userForm), "0.0");
        this.retailPrice = StringUtil.defaultString(CartItem.getRetailPriceFormat(aoSetting, detail, userForm), "0.0");

        this.taxBracketCd = item.getTaxBracketCd();
        this.taxExemptDiv = item.getTaxExemptDiv();
        this.taxPrice = StringUtil.defaultString(StringUtil.toBigDecimal(String.valueOf(detail.get("tax_price")), new BigDecimal(0.0)), "0.0");
        this.taxRate = StringUtil.toDouble(String.valueOf(detail.get("tax_rate")), 0.0);

        this.taxDiv = user.getTaxDiv();
        this.taxCalcDiv = user.getTaxCalcDiv();
        this.taxFractionDigitDiv = user.getTaxFractionDigitDiv();
        this.taxFractionDiv = user.getTaxFractionDiv();

        // TODO フラグ類
        this.shipmentEndFlg = Integer.parseInt(ShipmentEndFlg.NO);
        this.aoFlg = Integer.parseInt(AoFlg.NO);
        this.cancelFlg = Integer.parseInt(CancelFlg.NO);
        this.shipmentCompDiv = Integer.parseInt(ShipmentCompDiv.NO);
    }

    /** AOフラグ */
    public static class AoFlg {
        /** 未連携 */
        public static final String NO = "0";
        /** 連携済み */
        public static final String YES = "1";

    }

    /** キャンセルフラグ */
    public static class CancelFlg {
        /** 通常 */
        public static final String NO = "0";
        /** キャンセル済み */
        public static final String YES = "1";

    }

    /** 出荷フラグ */
    public static class ShipmentEndFlg {
        /** 条件なし */
        public static final String NOT = "9";
        /** 未出荷 */
        public static final String NO = "0";
        /** 出荷済み */
        public static final String YES = "1";
        /** 一部出荷 */
        public static final String PART = "2";
        /** キャンセル済み */
        public static final String CANCEL = "3";

    }

    /** 出荷完了区分 */
    public static class ShipmentCompDiv {
        /** 条件なし */
        public static final String NOT = "9";
        /** 未出荷 */
        public static final String NO = "0";
        /** 出荷済み */
        public static final String YES = "1";
        /** 一部出荷 */
        public static final String PART = "2";
    }

    private String orderNo;
    private int recordNo;
    private String userCd;
    private String itemCd;
    private String itemName1;
    private String itemName2;
    private String userItemCd;
    private String userItemName1;
    private String userItemName2;
    private String quantityPerCase;
    private String orderCaseQuantity;
    private String shipmentDate;
    private String shippingDate;
    private String shipmentCaseQuantity;
    private String unshippedCaseQuantity;
    private String orderQuantity;
    private String shipmentQuantity;
    private String unshippedQuantity;
    private String wholesalePrice;
    private String retailPrice;
    //private String userItemNo;
    private String unit;

    private int taxCalcDiv;
    private int taxFractionDigitDiv;
    private int taxFractionDiv;
    private int taxExemptDiv;
    private int taxBracketCd;
    private int taxDiv;

    private int shipmentEndFlg;
    private int shipmentCompDiv;

    private Double taxRate;
    private String taxPrice;
    private int aoFlg;
    private int cancelFlg;
    private int webPriceUseDiv;
    private int csvFlg;

    @FormProperty
    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @FormProperty
    public int getRecordNo() {
        return recordNo;
    }

    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    @FormProperty
    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    @FormProperty
    public String getItemCd() {
        return itemCd;
    }

    public void setItemCd(String itemCd) {
        this.itemCd = itemCd;
    }

    @FormProperty
    public String getItemName1() {
        return itemName1;
    }

    public void setItemName1(String itemName1) {
        this.itemName1 = itemName1;
    }

    @FormProperty
    public String getItemName2() {
        return itemName2;
    }

    public void setItemName2(String itemName2) {
        this.itemName2 = itemName2;
    }

    @FormProperty
    public String getUserItemCd() {
        return userItemCd;
    }

    public void setUserItemCd(String userItemCd) {
        this.userItemCd = userItemCd;
    }

    @FormProperty
    public String getUserItemName1() {
        return userItemName1;
    }

    public void setUserItemName1(String userItemName1) {
        this.userItemName1 = userItemName1;
    }

    @FormProperty
    public String getUserItemName2() {
        return userItemName2;
    }

    public void setUserItemName2(String userItemName2) {
        this.userItemName2 = userItemName2;
    }

    @FormProperty
    public String getQuantityPerCase() {
        return quantityPerCase;
    }

    public void setQuantityPerCase(String quantityPerCase) {
        this.quantityPerCase = quantityPerCase;
    }

    @FormProperty
    public String getOrderCaseQuantity() {
        return orderCaseQuantity;
    }

    public void setOrderCaseQuantity(String orderCaseQuantity) {
        this.orderCaseQuantity = orderCaseQuantity;
    }

    @FormProperty
    public String getShipmentDate() {
        return shipmentDate;
    }

    public void setShipmentDate(String shipmentDate) {
        this.shipmentDate = shipmentDate;
    }

    @FormProperty
    public String getShippingDate() {
        return shippingDate;
    }

    public void setShippingDate(String shippingDate) {
        this.shippingDate = shippingDate;
    }

    @FormProperty
    public String getShipmentCaseQuantity() {
        return shipmentCaseQuantity;
    }

    public void setShipmentCaseQuantity(String shipmentCaseQuantity) {
        this.shipmentCaseQuantity = shipmentCaseQuantity;
    }

    @FormProperty
    public String getUnshippedCaseQuantity() {
        return unshippedCaseQuantity;
    }

    public void setUnshippedCaseQuantity(String unshippedCaseQuantity) {
        this.unshippedCaseQuantity = unshippedCaseQuantity;
    }

    @FormProperty
    public String getOrderQuantity() {
        return orderQuantity;
    }

    public void setOrderQuantity(String orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    @FormProperty
    public String getShipmentQuantity() {
        return shipmentQuantity;
    }

    public void setShipmentQuantity(String shipmentQuantity) {
        this.shipmentQuantity = shipmentQuantity;
    }

    @FormProperty
    public String getUnshippedQuantity() {
        return unshippedQuantity;
    }

    public void setUnshippedQuantity(String unshippedQuantity) {
        this.unshippedQuantity = unshippedQuantity;
    }

    @FormProperty
    public String getWholesalePrice() {
        return wholesalePrice;
    }

    public void setWholesalePrice(String wholesalePrice) {
        this.wholesalePrice = wholesalePrice;
    }

    @FormProperty
    public String getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(String retailPrice) {
        this.retailPrice = retailPrice;
    }

//    @FormProperty
//    public String getUserItemNo() {
//        return userItemNo;
//    }
//
//    public void setUserItemNo(String userItemNo) {
//        this.userItemNo = userItemNo;
//    }

    @FormProperty
    public int getShipmentEndFlg() {
        return shipmentEndFlg;
    }

    public void setShipmentEndFlg(int shipmentEndFlg) {
        this.shipmentEndFlg = shipmentEndFlg;
    }

    @FormProperty
    public int getAoFlg() {
        return aoFlg;
    }

    public void setAoFlg(int aoFlg) {
        this.aoFlg = aoFlg;
    }

    @FormProperty
    public int getCancelFlg() {
        return cancelFlg;
    }

    public void setCancelFlg(int cancelFlg) {
        this.cancelFlg = cancelFlg;
    }

    @FormProperty
    public String getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(String taxPrice) {
        this.taxPrice = taxPrice;
    }

    /**
	 * unitを取得します。
	 * @return unit
	 */
	@FormProperty
	public String getUnit() {
	    return unit;
	}

	/**
	 * unitを設定します。
	 * @param unit unit
	 */
	public void setUnit(String unit) {
	    this.unit = unit;
	}

	@FormProperty
    public int getTaxCalcDiv() {
        return taxCalcDiv;
    }

    public void setTaxCalcDiv(int taxCalcDiv) {
        this.taxCalcDiv = taxCalcDiv;
    }

    @FormProperty
    public int getTaxFractionDigitDiv() {
        return taxFractionDigitDiv;
    }

    public void setTaxFractionDigitDiv(int taxFractionDigitDiv) {
        this.taxFractionDigitDiv = taxFractionDigitDiv;
    }

    @FormProperty
    public int getTaxFractionDiv() {
        return taxFractionDiv;
    }

    public void setTaxFractionDiv(int taxFractionDiv) {
        this.taxFractionDiv = taxFractionDiv;
    }

    @FormProperty
    public int getTaxExemptDiv() {
        return taxExemptDiv;
    }

    public void setTaxExemptDiv(int taxExemptDiv) {
        this.taxExemptDiv = taxExemptDiv;
    }

    @FormProperty
    public int getTaxBracketCd() {
        return taxBracketCd;
    }

    public void setTaxBracketCd(int taxBracketCd) {
        this.taxBracketCd = taxBracketCd;
    }

    @FormProperty
    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    @FormProperty
    public int getTaxDiv() {
        return taxDiv;
    }

    public void setTaxDiv(int taxDiv) {
        this.taxDiv = taxDiv;
    }

    @FormProperty
    public int getWebPriceUseDiv() {
        return webPriceUseDiv;
    }

    public void setWebPriceUseDiv(int webPriceUseDiv) {
        this.webPriceUseDiv = webPriceUseDiv;
    }

    @FormProperty
    public int getCsvFlg() {
        return csvFlg;
    }

    public void setCsvFlg(int csvFlg) {
        this.csvFlg = csvFlg;
    }

    @FormProperty
    public int getShipmentCompDiv() {
        return shipmentCompDiv;
    }

    public void setShipmentCompDiv(int shipmentCompDiv) {
        this.shipmentCompDiv = shipmentCompDiv;
    }

}
