package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class OrderCampaign implements DomainObject {

    private String campaignCd;
    private String campaignTitle;
    private String startDate;
    private String endDate;

    private Integer discountDiv;
    private BigDecimal discountRate;
    private BigDecimal fixedDiscountPrice;

    private BigDecimal discountAmountBorder;
    private Integer validFlg;

	@FormProperty
    public String getCampaignCd() {
        return campaignCd;
    }
    public void setCampaignCd(String campaignCd) {
        this.campaignCd = campaignCd;
    }
	@FormProperty
    public String getCampaignTitle() {
        return campaignTitle;
    }
    public void setCampaignTitle(String campaignTitle) {
        this.campaignTitle = campaignTitle;
    }
	@FormProperty
    public String getStartDate() {
        return startDate;
    }
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
	@FormProperty
    public String getEndDate() {
        return endDate;
    }
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
	@FormProperty
    public Integer getDiscountDiv() {
        return discountDiv;
    }
    public void setDiscountDiv(Integer discountDiv) {
        this.discountDiv = discountDiv;
    }
	@FormProperty
    public BigDecimal getDiscountRate() {
        return discountRate;
    }
    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }
	@FormProperty
    public BigDecimal getFixedDiscountPrice() {
        return fixedDiscountPrice;
    }
    public void setFixedDiscountPrice(BigDecimal fixedDiscountPrice) {
        this.fixedDiscountPrice = fixedDiscountPrice;
    }
	@FormProperty
    public BigDecimal getDiscountAmountBorder() {
        return discountAmountBorder;
    }

    public BigDecimal getDiscountAmountBorderIntax(Double taxRate, String taxDiv) {
    	if (Tax.TaxDiv.INCLUDING.equals(taxDiv)) {
    		return new BigDecimal(UtilTools.multiplyBigDecimal(discountAmountBorder.toString(), String.valueOf(taxRate)));
    	} else {
    		return new BigDecimal(discountAmountBorder.toString());
    	}
    }

    public void setDiscountAmountBorder(BigDecimal discountAmountBorder) {
        this.discountAmountBorder = discountAmountBorder;
    }
	@FormProperty
    public Integer getValidFlg() {
        return validFlg;
    }
    public void setValidFlg(Integer validFlg) {
        this.validFlg = validFlg;
    }

    public static OrderCampaign valueOf(Map<String, Object> map) {
        OrderCampaign orderCampaign = new OrderCampaign();

        orderCampaign.campaignCd = String.valueOf(map.get("campaign_cd"));
        orderCampaign.campaignTitle = String.valueOf(map.get("campaign_title"));
        orderCampaign.startDate = String.valueOf(map.get("start_date"));
        orderCampaign.endDate = String.valueOf(map.get("end_date"));
        orderCampaign.discountDiv = StringUtil.toInteger(String.valueOf(map.get("discount_div")), 0);

        if (map.get("discount_rate") != null && !"".equals(map.get("discount_rate"))) {
            orderCampaign.discountRate = new BigDecimal(StringUtil.defaultString(map.get("discount_rate"), "0.0"));
        }
        if (map.get("fixed_discount_price") != null && !"".equals(map.get("fixed_discount_price"))) {
            orderCampaign.fixedDiscountPrice = new BigDecimal(StringUtil.defaultString(map.get("fixed_discount_price"), "0.0"));
        }
        if (map.get("discount_amount_border") != null && !"".equals(map.get("discount_amount_border")) ) {
            orderCampaign.discountAmountBorder = new BigDecimal(StringUtil.defaultString(map.get("discount_amount_border"), "0.0"));
        }

        orderCampaign.validFlg = StringUtil.toInteger(String.valueOf(map.get("valid_flg")), 0);

        return orderCampaign;
    }
}
