package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.LinkedHashMap;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.model.Payment.AccountWayDiv;
import jp.ill.photon.model.SmbcPayment.ApiLink;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class Order implements DomainObject {

	public Order() {

	}

	private String orderNo;

	private String orderDate;

	private String shipmentDate;

	@DefaultParamSetting(transferType = "param", transferVal = "order.wishing_shipment_date")
	private String wishingShipmentDate;

	// 合計の値はOrderに持たなくする？
	private BigDecimal wholeSalePrice;

	private BigDecimal retailPrice;

	private BigDecimal taxPrice;

	private String totalOrderQuantity;

	private String totalShipmentQuantity;

	private String totalUnshippedQuantity;

	private String userCd;

	private String userDeliveryCd;

	private String userDeliveryName1;

	private String userDeliveryName2;

	private String zip;

	private String cityName1;

	private String cityName2;

	private String cityName3;

	private String tel;

	private String fax;

	@DefaultParamSetting(transferType = "param", transferVal = "order.user_order_no")
	private String userOrderNo;

	@DefaultParamSetting(transferType = "param", transferVal = "order.remarks")
	private String remarks;

	private String orderMakeUserChargeId;

	private int shipmentCompDiv;

	private String estimateNo;

	private String userSiteDispEndTime;

	private String userChargeName;

	@DefaultParamSetting(transferType = "param", transferVal = "order.area_name")
	private String areaName;

	@DefaultParamSetting(transferType = "param", transferVal = "order.delivery_fee_cd")
	private String deliveryFeeCd;

	@DefaultParamSetting(transferType = "param_multi", transferVal = "order.cart_id")
	private String[] cartId;

	@DefaultParamSetting(transferType = "param_multi", transferVal = "order.item_cd")
	private String[] itemCd;

	@DefaultParamSetting(transferType = "param_multi", transferVal = "order.quantity")
	private String[] quantity;

	@DefaultParamSetting(transferType = "param_multi", transferVal = "order.case_quantity")
	private String[] caseQuantity;

	private int importPermitDiv;

	@DefaultParamSetting(transferType = "param", transferVal = "selected_payment_cd")
	private String paymentCd;

	@DefaultParamSetting(transferType = "param", transferVal = "selected_payment_name")
	private String paymentName;

	@DefaultParamSetting(transferType = "param", transferVal = "selected_convenience_payment_cd")
	private String conveniencePaymentCd;

	/** クレジットカード番号 */
	@DefaultParamSetting(transferType = "param", transferVal = "order.credit_number")
	private String creditNumber;
	/** クレジットカード有効期限月 */
	@DefaultParamSetting(transferType = "param", transferVal = "order.credit_limit_month")
	private String creditLimitMonth;
	/** クレジットカード有効期限年 */
	@DefaultParamSetting(transferType = "param", transferVal = "order.credit_limit_year")
	private String creditLimitYear;
	/** クレジット支払方法 */
	@DefaultParamSetting(transferType = "param", transferVal = "selected_credit_payment_cd")
	private String creditPaymentMethodCd;
	/** クレジット支払回数 */
	@DefaultParamSetting(transferType = "param", transferVal = "selected_credit_number_of_payment_cd")
	private String creditNumberOfPaymentCd;
	/** クレジットセキュリティコード */
	@DefaultParamSetting(transferType = "param", transferVal = "order.credit_security_cd")
	private String creditSecurityCd;

	@DefaultParamSetting(transferType = "param", transferVal = "order.delivery_fee")
	private BigDecimal deliveryFee;

	@DefaultParamSetting(transferType = "param", transferVal = "order.charge_fee")
	private BigDecimal chargeFee;

	@DefaultParamSetting(transferType = "param", transferVal = "order.web_campaign")
	private BigDecimal webCampaign;

	@FormProperty
	public String getPaymentName() {
		return paymentName;
	}

	public void setPaymentName(String paymentName) {
		this.paymentName = paymentName;
	}

	@FormProperty
	public String getDeliveryFeeCd() {
		return deliveryFeeCd;
	}

	public void setDeliveryFeeCd(String deliveryFeeCd) {
		this.deliveryFeeCd = deliveryFeeCd;
	}

	@FormProperty
	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public String[] getItemCd() {
		return itemCd;
	}

	public void setItemCd(String[] itemCd) {
		this.itemCd = itemCd;
	}

	public BigDecimal getWebCampaign() {
		return webCampaign;
	}

	public void setWebCampaign(BigDecimal webCampaign) {
		this.webCampaign = webCampaign;
	}

	public BigDecimal getChargeFee() {
		return chargeFee;
	}

	public void setChargeFee(BigDecimal chargeFee) {
		this.chargeFee = chargeFee;
	}

	public BigDecimal getDeliveryFee() {
		return deliveryFee;
	}

	public void setDeliveryFee(BigDecimal deliveryFee) {
		this.deliveryFee = deliveryFee;
	}

	@FormProperty
	public String getMaskedCreditNumber() {

		int dispDigits = Payment.CREDIT_CARD_NO_DISP;
		StringBuffer ret = new StringBuffer();

		if (CheckUtil.isEmpty(creditNumber)) {
			dispDigits = 0;
		} else {
			if (creditNumber.length() < Payment.CREDIT_CARD_NO_DISP) {
				dispDigits = creditNumber.length();
			}
		}

		// 1～12桁目
		for (int i = 0; i < Payment.CREDIT_CARD_NO - dispDigits; i++) {
			ret.append("*");
		}

		if (dispDigits > 0) {
			ret.append(
					creditNumber.substring(creditNumber.length() - dispDigits));
		}

		return ret.toString();
	}

	@FormProperty
	public String getCreditSecurityCd() {
		return creditSecurityCd;
	}

	public void setCreditSecurityCd(String creditSecurityCd) {
		this.creditSecurityCd = creditSecurityCd;
	}

	@FormProperty
	public String isCreditPaymentMethodDivide() {
		return String.valueOf(AccountWayDiv.CREDIT_SMBC.equals(this.paymentCd)
				&& ApiLink.CreditPayDiv.DEVIDED_PAYMENT_EC2B
						.equals(creditPaymentMethodCd));
	}

	public boolean isCreditPaymentMethodDivideRaw() {
		return AccountWayDiv.CREDIT_SMBC.equals(this.paymentCd)
				&& ApiLink.CreditPayDiv.DEVIDED_PAYMENT_EC2B
						.equals(creditPaymentMethodCd);
	}

	@FormProperty
	public String getCreditPaymentMethodCd() {
		return creditPaymentMethodCd;
	}

	public void setCreditPaymentMethodCd(String creditPaymentMethodCd) {
		this.creditPaymentMethodCd = creditPaymentMethodCd;
	}

	@FormProperty
	public String getCreditNumberOfPaymentCd() {
		return creditNumberOfPaymentCd;
	}

	public void setCreditNumberOfPaymentCd(String creditNumberOfPaymentCd) {
		this.creditNumberOfPaymentCd = creditNumberOfPaymentCd;
	}

	@FormProperty
	public String getCreditNumber() {
		return creditNumber;
	}

	public void setCreditNumber(String creditNumber) {
		this.creditNumber = creditNumber;
	}

	@FormProperty
	public String getCreditLimitMonth() {
		return creditLimitMonth;
	}

	public void setCreditLimitMonth(String creditLimitMonth) {
		this.creditLimitMonth = creditLimitMonth;
	}

	@FormProperty
	public String getCreditLimitYear() {
		return creditLimitYear;
	}

	public void setCreditLimitYear(String creditLimitYear) {
		this.creditLimitYear = creditLimitYear;
	}

	@FormProperty
	public String getConveniencePaymentCd() {
		return conveniencePaymentCd;
	}

	public void setConveniencePaymentCd(String conveniencePaymentCd) {
		this.conveniencePaymentCd = conveniencePaymentCd;
	}

	@FormProperty
	public String getPaymentCd() {
		return paymentCd;
	}

	public void setPaymentCd(String paymentCd) {
		this.paymentCd = paymentCd;
	}

	public void setUser(User user) {
		this.userCd = user.getUserCd();
	}

	public void setDelivery(Delivery delivery) {
		this.userDeliveryCd = delivery.getUserDeliveryCd();
		this.userDeliveryName1 = delivery.getUserDeliveryName1();
		this.userDeliveryName2 = delivery.getUserDeliveryName2();
		this.zip = delivery.getZip();
		this.cityName1 = delivery.getCityName1();
		this.cityName2 = delivery.getCityName2();
		this.cityName3 = delivery.getCityName3();
		this.tel = delivery.getTel();
		this.fax = delivery.getFax();
	}

	// 移植元：CartPaymentBiz.calcTotalPriceImpl
	public BigDecimal getTaxWholesalePrice(String taxPriceForSum) {
		String totalPrice = wholeSalePrice.toString();

		// 総金額
		if (!CheckUtil.isEmpty(taxPriceForSum)) {
			totalPrice = UtilTools.addBigDecimal(totalPrice,
					taxPriceForSum.toString());
		}

		return new BigDecimal(totalPrice);
	}

	@FormProperty
	public String getImportPermitDiv() {
		return String.valueOf(importPermitDiv);
	}

	public void setImportPermitDiv(int importPermitDiv) {
		this.importPermitDiv = importPermitDiv;
	}

	@FormProperty
	public String getWishingShipmentDate() {
		return wishingShipmentDate;
	}

	public void setWishingShipmentDate(String wishingShipmentDate) {
		this.wishingShipmentDate = wishingShipmentDate;
	}

	@FormProperty
	public String getUserOrderNo() {
		return userOrderNo;
	}

	public void setUserOrderNo(String userOrderNo) {
		this.userOrderNo = userOrderNo;
	}

	@FormProperty
	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	/**
	 * userChargeNameを取得します。
	 *
	 * @return userChargeName
	 */
	@FormProperty
	public String getUserChargeName() {
		return userChargeName;
	}

	/**
	 * userChargeNameを設定します。
	 *
	 * @param userChargeName userChargeName
	 */
	public void setUserChargeName(String userChargeName) {
		this.userChargeName = userChargeName;
	}

	// DB登録対象外
	public String[] getCartId() {
		return cartId;
	}

	public void setCartId(String[] cartId) {
		this.cartId = cartId;
	}

	// DB登録対象外
	public String[] getQuantity() {
		return quantity;
	}

	public void setQuantity(String[] quantity) {
		this.quantity = quantity;
	}

	// DB登録対象外
	public String[] getCaseQuantity() {
		return caseQuantity;
	}

	public void setCaseQuantity(String[] caseQuantity) {
		this.caseQuantity = caseQuantity;
	}

	@FormProperty
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@FormProperty
	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	@FormProperty
	public String getShipmentDate() {
		return shipmentDate;
	}

	public void setShipmentDate(String shipmentDate) {
		this.shipmentDate = shipmentDate;
	}

	@FormProperty
	public String getWholesalePrice() {
		return wholeSalePrice == null ? "" : wholeSalePrice.toString();
	}

	public void setWholesalePrice(BigDecimal wholeSalePrice) {
		this.wholeSalePrice = wholeSalePrice;
	}

	@FormProperty
	public String getRetailPrice() {
		return retailPrice == null ? "" : retailPrice.toString();
	}

	public void setRetailPrice(BigDecimal retailPrice) {
		this.retailPrice = retailPrice;
	}

	@FormProperty
	public String getTaxPrice() {
		return taxPrice == null ? "" : taxPrice.toString();
	}

	public void setTaxPrice(BigDecimal taxPrice) {
		this.taxPrice = taxPrice;
	}

	@FormProperty
	public String getTotalOrderQuantity() {
		return totalOrderQuantity == null ? "" : totalOrderQuantity.toString();
	}

	public void setTotalOrderQuantity(BigDecimal totalOrderQuantity) {
		this.totalOrderQuantity =  StringUtil.defaultString(totalOrderQuantity, "0.0");
	}

	@FormProperty
	public String getTotalShipmentQuantity() {
		return totalShipmentQuantity == null ? ""
				: totalShipmentQuantity.toString();
	}

	public void setTotalShipmentQuantity(BigDecimal totalShipmentQuantity) {
		this.totalShipmentQuantity = StringUtil.defaultString(totalShipmentQuantity, "0.0");
	}

	@FormProperty
	public String getTotalUnshippedQuantity() {
		return totalUnshippedQuantity == null ? ""
				: totalUnshippedQuantity.toString();
	}

	public void setTotalUnshippedQuantity(BigDecimal totalUnshippedQuantity) {
		this.totalUnshippedQuantity = StringUtil.defaultString(totalUnshippedQuantity, "0.0");
	}

	@FormProperty
	public String getUserCd() {
		return userCd;
	}

	public void setUserCd(String userCd) {
		this.userCd = userCd;
	}

	@FormProperty
	public String getUserDeliveryCd() {
		return userDeliveryCd;
	}

	public void setUserDeliveryCd(String userDeliveryCd) {
		this.userDeliveryCd = userDeliveryCd;
	}

	@FormProperty
	public String getUserDeliveryName1() {
		return userDeliveryName1;
	}

	public void setUserDeliveryName1(String userDeliveryName1) {
		this.userDeliveryName1 = userDeliveryName1;
	}

	@FormProperty
	public String getUserDeliveryName2() {
		return userDeliveryName2;
	}

	public void setUserDeliveryName2(String userDeliveryName2) {
		this.userDeliveryName2 = userDeliveryName2;
	}

	@FormProperty
	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	@FormProperty
	public String getCityName1() {
		return cityName1;
	}

	public void setCityName1(String cityName1) {
		this.cityName1 = cityName1;
	}

	@FormProperty
	public String getCityName2() {
		return cityName2;
	}

	public void setCityName2(String cityName2) {
		this.cityName2 = cityName2;
	}

	@FormProperty
	public String getCityName3() {
		return cityName3;
	}

	public void setCityName3(String cityName3) {
		this.cityName3 = cityName3;
	}

	@FormProperty
	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	@FormProperty
	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	@FormProperty
	public String getOrderMakeUserChargeId() {
		return orderMakeUserChargeId;
	}

	public void setOrderMakeUserChargeId(String orderMakeuserChargeId) {
		this.orderMakeUserChargeId = orderMakeuserChargeId;
	}

	@FormProperty
	public String getShipmentCompDiv() {
		return String.valueOf(shipmentCompDiv);
	}

	public void setShipmentCompDiv(int shipmentCompDiv) {
		this.shipmentCompDiv = shipmentCompDiv;
	}

	@FormProperty
	public String getEstimateNo() {
		return estimateNo;
	}

	public void setEstimateNo(String estimateNo) {
		this.estimateNo = estimateNo;
	}

	@FormProperty
	public String getUserSiteDispEndTime() {
		return userSiteDispEndTime;
	}

	public void setUserSiteDispEndTime(String userSiteDispEndTime) {
		this.userSiteDispEndTime = userSiteDispEndTime;
	}

	/** 注文データ取込方式マップ */
	public static class takeInType {
		/** 自動 */
		public static final String AUTO = "0";
		/** 選択 */
		public static final String SELECT = "1";
		/** マップ */
		public static final LinkedHashMap<String, String> TAKE_IN_TYPE_MAP = new LinkedHashMap<String, String>();
		static {
			TAKE_IN_TYPE_MAP.put(AUTO, "自動");
			TAKE_IN_TYPE_MAP.put(SELECT, "選択");
		}
	}

	/** 取り込み許可区分 */
	public static class importPermitDiv {
		/** 不許可 */
		public static final String OFF = "0";
		/** 許可 */
		public static final String ON = "1";

		/* アラジンECtoB 2ndバージョンリリース #3605 START */
		/** 未処理 */
		public static final String NOT_YET = "0";
		/** 処理中 */
		public static final String IN_PROCESS = "1";
		/** 条件なし */
		public static final String NOT = "9";
		/* アラジンECtoB 2ndバージョンリリース #3605 END */

		/** マップ */
		public static final LinkedHashMap<String, String> INPORT_PERMIT_MAP = new LinkedHashMap<String, String>();
		static {
			INPORT_PERMIT_MAP.put(OFF, "不許可");
			INPORT_PERMIT_MAP.put(ON, "許可");
		}
		/* アラジンECtoB 2ndバージョンリリース #3605 START */
		/** マップ */
		public static final LinkedHashMap<String, String> IMPORT_PERMIT_DIV_MAP = new LinkedHashMap<String, String>();
		static {
			IMPORT_PERMIT_DIV_MAP.put(NOT, "条件なし");
			IMPORT_PERMIT_DIV_MAP.put(NOT_YET, "未処理");
			IMPORT_PERMIT_DIV_MAP.put(IN_PROCESS, "処理中");
		}
		/* アラジンECtoB 2ndバージョンリリース #3605 END */
	}

	public boolean isConvenienceSelected() {
		return AccountWayDiv.CONVENIENCE_STORE_RECEPTION_SMBC
				.equals(this.paymentCd);
	}

	public boolean isCreditSelected() {
		return AccountWayDiv.CREDIT_SMBC.equals(this.paymentCd);
	}

	public boolean isCreditSelected(String paymentCd) {
		return AccountWayDiv.CREDIT_SMBC.equals(paymentCd);
	}

}
