package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.LinkedHashMap;

public class Money {

    /** 端数処理区分 */
    public static class FractionDiv {
        /** 切り捨て */
        public static final String DOWN = "0";
        /** 四捨五入 */
        public static final String HALF_UP = "5";
        /** 切り上げ */
        public static final String UP = "9";
        /* アラジンECtoB 3rdバージョンリリース【オープンサイト承認あり版】 START */
        /** マップ */
        public static final LinkedHashMap<String, String> FRACTION_DIV_MAP = new LinkedHashMap<String, String>();
        static {
            FRACTION_DIV_MAP.put(DOWN, "切り捨て");
            FRACTION_DIV_MAP.put(HALF_UP, "四捨五入");
            FRACTION_DIV_MAP.put(UP, "切り上げ");
        }
        /* アラジンECtoB 3rdバージョンリリース【オープンサイト承認あり版】 END */
    }

    /** 端数処理 */
    public static class Fraction {

        public static final LinkedHashMap<String, Integer> FRACTION_MAP = new LinkedHashMap<String, Integer>();
        static {
            FRACTION_MAP.put(FractionDiv.DOWN, BigDecimal.ROUND_DOWN); // 切り捨て
            FRACTION_MAP.put(FractionDiv.HALF_UP, BigDecimal.ROUND_HALF_UP); // 四捨五入
            FRACTION_MAP.put(FractionDiv.UP, BigDecimal.ROUND_UP); // 切り上げ
        }
    }

}
