package jp.ill.photon.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 汎用リストパラメータ用モデル マップパラメータのsort_no順でvalの値をリストで保持する
 * 
 * @author h_tanaka
 *
 */
public class ListParam {

	private List<String> paramList;

	@SuppressWarnings("unchecked")
	public static ListParam valueOf(Map<String, Object> map) {
		ListParam param = new ListParam();
		List<String> values = param.getParamList();

		Map<String, Object> subMap = null;
		for (Map.Entry<String, Object> entry : map.entrySet()) {
			subMap = (Map<String, Object>) entry.getValue();
			values.add(String.valueOf(subMap.get("val")));
		}

		param.setParamList(values);

		return param;
	}

	public List<String> getParamList() {
		if (paramList == null) {
			paramList = new ArrayList<>();
		}
		return paramList;
	}

	public void setParamList(List<String> paramList) {
		this.paramList = paramList;
	}
}
