package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.util.StringUtil;

import org.apache.commons.lang3.StringUtils;

public class Item {

    private String itemCd;
    private String itemName1;
    private String itemName2;
    private String itemNameKana;
    private BigDecimal quantityPerCase;
    private int taxExemptDiv;
    private int taxBracketCd;
    private String userItemCd;
    private String userItemName1;
    private String userItemName2;

    private String unit;
    private BigDecimal saleUnitPriceNoTax;
    private BigDecimal saleUnitPriceInTax;
    private BigDecimal retailPrice;
    private BigDecimal retailPriceTaxIncluded;
    private BigDecimal rankPrice1;
    private BigDecimal rankPrice2;
    private BigDecimal rankPrice3;
    private BigDecimal rankPrice4;
    private BigDecimal rankPrice5;
    private BigDecimal rankPrice6;
    private BigDecimal rankPrice7;
    private BigDecimal rankPrice8;
    private BigDecimal rankPrice9;
    private BigDecimal rankPrice10;
    private String itemCategoryCd1;
    private String itemCategoryCd2;
    private String itemCategoryCd3;
    private String itemCategoryCd4;
    private String itemCategoryCd5;
    private String itemCategoryCd6;
    private String itemCategoryCd7;
    private String itemCategoryCd8;
    private String itemCategoryCd9;
    private String itemCategoryCd10;
    private String unitPriceCategoryCd;
    private String remarks1;
    private String remarks2;
    private String remarks3;
    private Integer stockDiv;
    private Integer stockManageDiv;
    private Integer dispFlg;

    private Integer userActiveItemUseFlg;
    private Integer userCartbtDispUseFlg;
    private String janCd;
    private String memo;
    private Integer rankingNo;
    private String webRemarks1;
    private String webRemarks2;
    private String metaDescription;
    private String metaKeywords;
    private String itemImage1;
    private String itemImage2;
    private String itemImage3;
    private String itemImage4;
    private String itemImage5;
    private Integer inventoryCheckFlg;
    private String updateUserName;
    private String updateDatetime;
    private Integer updateDiv;
    private String insertUserName;
    private String insertDatetime;
    private Integer insertDiv;

    private BigDecimal wholeSalePrice;

    private int itemDispFlg;
    private int cartDispFlg;

    public BigDecimal getWholeSalePrice() {
        return wholeSalePrice;
    }

    public void setWholeSalePrice(BigDecimal wholeSalePrice) {
        this.wholeSalePrice = wholeSalePrice;
    }

    public int getItemDispFlg() {
        return itemDispFlg;
    }

    public void setItemDispFlg(int itemDispFlg) {
        this.itemDispFlg = itemDispFlg;
    }

    public int getCartDispFlg() {
        return cartDispFlg;
    }

    public void setCartDispFlg(int cartDispFlg) {
        this.cartDispFlg = cartDispFlg;
    }

    public String getItemNameKana() {
        return itemNameKana;
    }

    public void setItemNameKana(String itemNameKana) {
        this.itemNameKana = itemNameKana;
    }

    public BigDecimal getQuantityPerCase() {
        return quantityPerCase;
    }

    public void setQuantityPerCase(BigDecimal quantityPerCase) {
        this.quantityPerCase = quantityPerCase;
    }

    public String getItemCd() {
        return itemCd;
    }

    public void setItemCd(String itemCd) {
        this.itemCd = itemCd;
    }

    public String getItemName1() {
        return itemName1;
    }

    public void setItemName1(String itemName1) {
        this.itemName1 = itemName1;
    }

    public String getItemName2() {
        return itemName2;
    }

    public void setItemName2(String itemName2) {
        this.itemName2 = itemName2;
    }

    public int getTaxExemptDiv() {
        return taxExemptDiv;
    }

    public void setTaxExemptDiv(int taxExemptDiv) {
        this.taxExemptDiv = taxExemptDiv;
    }

    public int getTaxBracketCd() {
        return taxBracketCd;
    }

    public void setTaxBracketCd(int taxBracketCd) {
        this.taxBracketCd = taxBracketCd;
    }

    public String getUserItemCd() {
        return userItemCd;
    }

    public void setUserItemCd(String userItemCd) {
        this.userItemCd = userItemCd;
    }

    public String getUserItemName1() {
        return userItemName1;
    }

    public void setUserItemName1(String userItemName1) {
        this.userItemName1 = userItemName1;
    }

    public String getUserItemName2() {
        return userItemName2;
    }

    public void setUserItemName2(String userItemName2) {
        this.userItemName2 = userItemName2;
    }

	/**
	 * unitを取得します。
	 * @return unit
	 */
	public String getUnit() {
		return unit;
	}

	/**
	 * unitを設定します。
	 * @param unit
	 */
	public void setUnit(String unit) {
		this.unit = unit;
	}

	/**
	 * saleUnitPriceNoTaxを取得します。
	 * @return saleUnitPriceNoTax
	 */
	public BigDecimal getSaleUnitPriceNoTax() {
		return saleUnitPriceNoTax;
	}

	/**
	 * saleUnitPriceNoTaxを設定します。
	 * @param saleUnitPriceNoTax
	 */
	public void setSaleUnitPriceNoTax(BigDecimal saleUnitPriceNoTax) {
		this.saleUnitPriceNoTax = saleUnitPriceNoTax;
	}

	/**
	 * saleUnitPriceInTaxを取得します。
	 * @return saleUnitPriceInTax
	 */
	public BigDecimal getSaleUnitPriceInTax() {
		return saleUnitPriceInTax;
	}

	/**
	 * saleUnitPriceInTaxを設定します。
	 * @param saleUnitPriceInTax
	 */
	public void setSaleUnitPriceInTax(BigDecimal saleUnitPriceInTax) {
		this.saleUnitPriceInTax = saleUnitPriceInTax;
	}

	/**
	 * retailPriceを取得します。
	 * @return retailPrice
	 */
	public BigDecimal getRetailPrice() {
		return retailPrice;
	}

	/**
	 * retailPriceを設定します。
	 * @param retailPrice
	 */
	public void setRetailPrice(BigDecimal retailPrice) {
		this.retailPrice = retailPrice;
	}

	/**
	 * retailPriceTaxIncludedを取得します。
	 * @return retailPriceTaxIncluded
	 */
	public BigDecimal getRetailPriceTaxIncluded() {
		return retailPriceTaxIncluded;
	}

	/**
	 * retailPriceTaxIncludedを設定します。
	 * @param retailPriceTaxIncluded
	 */
	public void setRetailPriceTaxIncluded(BigDecimal retailPriceTaxIncluded) {
		this.retailPriceTaxIncluded = retailPriceTaxIncluded;
	}

	/**
	 * rankPrice1を取得します。
	 * @return rankPrice1
	 */
	public BigDecimal getRankPrice1() {
		return rankPrice1;
	}

	/**
	 * rankPrice1を設定します。
	 * @param rankPrice1
	 */
	public void setRankPrice1(BigDecimal rankPrice1) {
		this.rankPrice1 = rankPrice1;
	}

	/**
	 * rankPrice2を取得します。
	 * @return rankPrice2
	 */
	public BigDecimal getRankPrice2() {
		return rankPrice2;
	}

	/**
	 * rankPrice2を設定します。
	 * @param rankPrice2
	 */
	public void setRankPrice2(BigDecimal rankPrice2) {
		this.rankPrice2 = rankPrice2;
	}

	/**
	 * rankPrice3を取得します。
	 * @return rankPrice3
	 */
	public BigDecimal getRankPrice3() {
		return rankPrice3;
	}

	/**
	 * rankPrice3を設定します。
	 * @param rankPrice3
	 */
	public void setRankPrice3(BigDecimal rankPrice3) {
		this.rankPrice3 = rankPrice3;
	}

	/**
	 * rankPrice4を取得します。
	 * @return rankPrice4
	 */
	public BigDecimal getRankPrice4() {
		return rankPrice4;
	}

	/**
	 * rankPrice4を設定します。
	 * @param rankPrice4
	 */
	public void setRankPrice4(BigDecimal rankPrice4) {
		this.rankPrice4 = rankPrice4;
	}

	/**
	 * rankPrice5を取得します。
	 * @return rankPrice5
	 */
	public BigDecimal getRankPrice5() {
		return rankPrice5;
	}

	/**
	 * rankPrice5を設定します。
	 * @param rankPrice5
	 */
	public void setRankPrice5(BigDecimal rankPrice5) {
		this.rankPrice5 = rankPrice5;
	}

	/**
	 * rankPrice6を取得します。
	 * @return rankPrice6
	 */
	public BigDecimal getRankPrice6() {
		return rankPrice6;
	}

	/**
	 * rankPrice6を設定します。
	 * @param rankPrice6
	 */
	public void setRankPrice6(BigDecimal rankPrice6) {
		this.rankPrice6 = rankPrice6;
	}

	/**
	 * rankPrice7を取得します。
	 * @return rankPrice7
	 */
	public BigDecimal getRankPrice7() {
		return rankPrice7;
	}

	/**
	 * rankPrice7を設定します。
	 * @param rankPrice7
	 */
	public void setRankPrice7(BigDecimal rankPrice7) {
		this.rankPrice7 = rankPrice7;
	}

	/**
	 * rankPrice8を取得します。
	 * @return rankPrice8
	 */
	public BigDecimal getRankPrice8() {
		return rankPrice8;
	}

	/**
	 * rankPrice8を設定します。
	 * @param rankPrice8
	 */
	public void setRankPrice8(BigDecimal rankPrice8) {
		this.rankPrice8 = rankPrice8;
	}

	/**
	 * rankPrice9を取得します。
	 * @return rankPrice9
	 */
	public BigDecimal getRankPrice9() {
		return rankPrice9;
	}

	/**
	 * rankPrice9を設定します。
	 * @param rankPrice9
	 */
	public void setRankPrice9(BigDecimal rankPrice9) {
		this.rankPrice9 = rankPrice9;
	}

	/**
	 * rankPrice10を取得します。
	 * @return rankPrice10
	 */
	public BigDecimal getRankPrice10() {
		return rankPrice10;
	}

	/**
	 * rankPrice10を設定します。
	 * @param rankPrice10
	 */
	public void setRankPrice10(BigDecimal rankPrice10) {
		this.rankPrice10 = rankPrice10;
	}

	/**
	 * itemCategoryCd1を取得します。
	 * @return itemCategoryCd1
	 */
	public String getItemCategoryCd1() {
		return itemCategoryCd1;
	}

	/**
	 * itemCategoryCd1を設定します。
	 * @param itemCategoryCd1
	 */
	public void setItemCategoryCd1(String itemCategoryCd1) {
		this.itemCategoryCd1 = itemCategoryCd1;
	}

	/**
	 * itemCategoryCd2を取得します。
	 * @return itemCategoryCd2
	 */
	public String getItemCategoryCd2() {
		return itemCategoryCd2;
	}

	/**
	 * itemCategoryCd2を設定します。
	 * @param itemCategoryCd2
	 */
	public void setItemCategoryCd2(String itemCategoryCd2) {
		this.itemCategoryCd2 = itemCategoryCd2;
	}

	/**
	 * itemCategoryCd3を取得します。
	 * @return itemCategoryCd3
	 */
	public String getItemCategoryCd3() {
		return itemCategoryCd3;
	}

	/**
	 * itemCategoryCd3を設定します。
	 * @param itemCategoryCd3
	 */
	public void setItemCategoryCd3(String itemCategoryCd3) {
		this.itemCategoryCd3 = itemCategoryCd3;
	}

	/**
	 * itemCategoryCd4を取得します。
	 * @return itemCategoryCd4
	 */
	public String getItemCategoryCd4() {
		return itemCategoryCd4;
	}

	/**
	 * itemCategoryCd4を設定します。
	 * @param itemCategoryCd4
	 */
	public void setItemCategoryCd4(String itemCategoryCd4) {
		this.itemCategoryCd4 = itemCategoryCd4;
	}

	/**
	 * itemCategoryCd5を取得します。
	 * @return itemCategoryCd5
	 */
	public String getItemCategoryCd5() {
		return itemCategoryCd5;
	}

	/**
	 * itemCategoryCd5を設定します。
	 * @param itemCategoryCd5
	 */
	public void setItemCategoryCd5(String itemCategoryCd5) {
		this.itemCategoryCd5 = itemCategoryCd5;
	}

	/**
	 * itemCategoryCd6を取得します。
	 * @return itemCategoryCd6
	 */
	public String getItemCategoryCd6() {
		return itemCategoryCd6;
	}

	/**
	 * itemCategoryCd6を設定します。
	 * @param itemCategoryCd6
	 */
	public void setItemCategoryCd6(String itemCategoryCd6) {
		this.itemCategoryCd6 = itemCategoryCd6;
	}

	/**
	 * itemCategoryCd7を取得します。
	 * @return itemCategoryCd7
	 */
	public String getItemCategoryCd7() {
		return itemCategoryCd7;
	}

	/**
	 * itemCategoryCd7を設定します。
	 * @param itemCategoryCd7
	 */
	public void setItemCategoryCd7(String itemCategoryCd7) {
		this.itemCategoryCd7 = itemCategoryCd7;
	}

	/**
	 * itemCategoryCd8を取得します。
	 * @return itemCategoryCd8
	 */
	public String getItemCategoryCd8() {
		return itemCategoryCd8;
	}

	/**
	 * itemCategoryCd8を設定します。
	 * @param itemCategoryCd8
	 */
	public void setItemCategoryCd8(String itemCategoryCd8) {
		this.itemCategoryCd8 = itemCategoryCd8;
	}

	/**
	 * itemCategoryCd9を取得します。
	 * @return itemCategoryCd9
	 */
	public String getItemCategoryCd9() {
		return itemCategoryCd9;
	}

	/**
	 * itemCategoryCd9を設定します。
	 * @param itemCategoryCd9
	 */
	public void setItemCategoryCd9(String itemCategoryCd9) {
		this.itemCategoryCd9 = itemCategoryCd9;
	}

	/**
	 * itemCategoryCd10を取得します。
	 * @return itemCategoryCd10
	 */
	public String getItemCategoryCd10() {
		return itemCategoryCd10;
	}

	/**
	 * itemCategoryCd10を設定します。
	 * @param itemCategoryCd10
	 */
	public void setItemCategoryCd10(String itemCategoryCd10) {
		this.itemCategoryCd10 = itemCategoryCd10;
	}

	/**
	 * unitPriceCategoryCdを取得します。
	 * @return unitPriceCategoryCd
	 */
	public String getUnitPriceCategoryCd() {
		return unitPriceCategoryCd;
	}

	/**
	 * unitPriceCategoryCdを設定します。
	 * @param unitPriceCategoryCd
	 */
	public void setUnitPriceCategoryCd(String unitPriceCategoryCd) {
		this.unitPriceCategoryCd = unitPriceCategoryCd;
	}

	/**
	 * remarks1を取得します。
	 * @return remarks1
	 */
	public String getRemarks1() {
		return remarks1;
	}

	/**
	 * remarks1を設定します。
	 * @param remarks1
	 */
	public void setRemarks1(String remarks1) {
		this.remarks1 = remarks1;
	}

	/**
	 * remarks2を取得します。
	 * @return remarks2
	 */
	public String getRemarks2() {
		return remarks2;
	}

	/**
	 * remarks2を設定します。
	 * @param remarks2
	 */
	public void setRemarks2(String remarks2) {
		this.remarks2 = remarks2;
	}

	/**
	 * remarks3を取得します。
	 * @return remarks3
	 */
	public String getRemarks3() {
		return remarks3;
	}

	/**
	 * remarks3を設定します。
	 * @param remarks3
	 */
	public void setRemarks3(String remarks3) {
		this.remarks3 = remarks3;
	}

	/**
	 * stockDivを取得します。
	 * @return stockDiv
	 */
	public Integer getStockDiv() {
		return stockDiv;
	}

	/**
	 * stockDivを設定します。
	 * @param stockDiv
	 */
	public void setStockDiv(Integer stockDiv) {
		this.stockDiv = stockDiv;
	}

	/**
	 * stockManageDivを取得します。
	 * @return stockManageDiv
	 */
	public Integer getStockManageDiv() {
		return stockManageDiv;
	}

	/**
	 * stockManageDivを設定します。
	 * @param stockManageDiv
	 */
	public void setStockManageDiv(Integer stockManageDiv) {
		this.stockManageDiv = stockManageDiv;
	}

	/**
	 * dispFlgを取得します。
	 * @return dispFlg
	 */
	public Integer getDispFlg() {
		return dispFlg;
	}

	/**
	 * dispFlgを設定します。
	 * @param dispFlg
	 */
	public void setDispFlg(Integer dispFlg) {
		this.dispFlg = dispFlg;
	}

	/**
	 * userActiveItemUseFlgを取得します。
	 * @return userActiveItemUseFlg
	 */
	public Integer getUserActiveItemUseFlg() {
		return userActiveItemUseFlg;
	}

	/**
	 * userActiveItemUseFlgを設定します。
	 * @param userActiveItemUseFlg
	 */
	public void setUserActiveItemUseFlg(Integer userActiveItemUseFlg) {
		this.userActiveItemUseFlg = userActiveItemUseFlg;
	}

	/**
	 * userCartbtDispUseFlgを取得します。
	 * @return userCartbtDispUseFlg
	 */
	public Integer getUserCartbtDispUseFlg() {
		return userCartbtDispUseFlg;
	}

	/**
	 * userCartbtDispUseFlgを設定します。
	 * @param userCartbtDispUseFlg
	 */
	public void setUserCartbtDispUseFlg(Integer userCartbtDispUseFlg) {
		this.userCartbtDispUseFlg = userCartbtDispUseFlg;
	}

	/**
	 * janCdを取得します。
	 * @return janCd
	 */
	public String getJanCd() {
		return janCd;
	}

	/**
	 * janCdを設定します。
	 * @param janCd
	 */
	public void setJanCd(String janCd) {
		this.janCd = janCd;
	}

	/**
	 * memoを取得します。
	 * @return memo
	 */
	public String getMemo() {
		return memo;
	}

	/**
	 * memoを設定します。
	 * @param memo
	 */
	public void setMemo(String memo) {
		this.memo = memo;
	}

	/**
	 * rankingNoを取得します。
	 * @return rankingNo
	 */
	public Integer getRankingNo() {
		return rankingNo;
	}

	/**
	 * rankingNoを設定します。
	 * @param rankingNo
	 */
	public void setRankingNo(Integer rankingNo) {
		this.rankingNo = rankingNo;
	}

	/**
	 * webRemarks1を取得します。
	 * @return webRemarks1
	 */
	public String getWebRemarks1() {
		return webRemarks1;
	}

	/**
	 * webRemarks1を設定します。
	 * @param webRemarks1
	 */
	public void setWebRemarks1(String webRemarks1) {
		this.webRemarks1 = webRemarks1;
	}

	/**
	 * webRemarks2を取得します。
	 * @return webRemarks2
	 */
	public String getWebRemarks2() {
		return webRemarks2;
	}

	/**
	 * webRemarks2を設定します。
	 * @param webRemarks2
	 */
	public void setWebRemarks2(String webRemarks2) {
		this.webRemarks2 = webRemarks2;
	}

	/**
	 * metaDescriptionを取得します。
	 * @return metaDescription
	 */
	public String getMetaDescription() {
		return metaDescription;
	}

	/**
	 * metaDescriptionを設定します。
	 * @param metaDescription
	 */
	public void setMetaDescription(String metaDescription) {
		this.metaDescription = metaDescription;
	}

	/**
	 * metaKeywordsを取得します。
	 * @return metaKeywords
	 */
	public String getMetaKeywords() {
		return metaKeywords;
	}

	/**
	 * metaKeywordsを設定します。
	 * @param metaKeywords
	 */
	public void setMetaKeywords(String metaKeywords) {
		this.metaKeywords = metaKeywords;
	}

	/**
	 * itemImage1を取得します。
	 * @return itemImage1
	 */
	public String getItemImage1() {
		return itemImage1;
	}

	/**
	 * itemImage1を設定します。
	 * @param itemImage1
	 */
	public void setItemImage1(String itemImage1) {
		this.itemImage1 = itemImage1;
	}

	/**
	 * itemImage2を取得します。
	 * @return itemImage2
	 */
	public String getItemImage2() {
		return itemImage2;
	}

	/**
	 * itemImage2を設定します。
	 * @param itemImage2
	 */
	public void setItemImage2(String itemImage2) {
		this.itemImage2 = itemImage2;
	}

	/**
	 * itemImage3を取得します。
	 * @return itemImage3
	 */
	public String getItemImage3() {
		return itemImage3;
	}

	/**
	 * itemImage3を設定します。
	 * @param itemImage3
	 */
	public void setItemImage3(String itemImage3) {
		this.itemImage3 = itemImage3;
	}

	/**
	 * itemImage4を取得します。
	 * @return itemImage4
	 */
	public String getItemImage4() {
		return itemImage4;
	}

	/**
	 * itemImage4を設定します。
	 * @param itemImage4
	 */
	public void setItemImage4(String itemImage4) {
		this.itemImage4 = itemImage4;
	}

	/**
	 * itemImage5を取得します。
	 * @return itemImage5
	 */
	public String getItemImage5() {
		return itemImage5;
	}

	/**
	 * itemImage5を設定します。
	 * @param itemImage5
	 */
	public void setItemImage5(String itemImage5) {
		this.itemImage5 = itemImage5;
	}

	/**
	 * inventoryCheckFlgを取得します。
	 * @return inventoryCheckFlg
	 */
	public Integer getInventoryCheckFlg() {
		return inventoryCheckFlg;
	}

	/**
	 * inventoryCheckFlgを設定します。
	 * @param inventoryCheckFlg
	 */
	public void setInventoryCheckFlg(Integer inventoryCheckFlg) {
		this.inventoryCheckFlg = inventoryCheckFlg;
	}

	/**
	 * updateUserNameを取得します。
	 * @return updateUserName
	 */
	public String getUpdateUserName() {
		return updateUserName;
	}

	/**
	 * updateUserNameを設定します。
	 * @param updateUserName
	 */
	public void setUpdateUserName(String updateUserName) {
		this.updateUserName = updateUserName;
	}

	/**
	 * updateDatetimeを取得します。
	 * @return updateDatetime
	 */
	public String getUpdateDatetime() {
		return updateDatetime;
	}

	/**
	 * updateDatetimeを設定します。
	 * @param updateDatetime
	 */
	public void setUpdateDatetime(String updateDatetime) {
		this.updateDatetime = updateDatetime;
	}

	/**
	 * updateDivを取得します。
	 * @return updateDiv
	 */
	public Integer getUpdateDiv() {
		return updateDiv;
	}

	/**
	 * updateDivを設定します。
	 * @param updateDiv
	 */
	public void setUpdateDiv(Integer updateDiv) {
		this.updateDiv = updateDiv;
	}

	/**
	 * insertUserNameを取得します。
	 * @return insertUserName
	 */
	public String getInsertUserName() {
		return insertUserName;
	}

	/**
	 * insertUserNameを設定します。
	 * @param insertUserName
	 */
	public void setInsertUserName(String insertUserName) {
		this.insertUserName = insertUserName;
	}

	/**
	 * insertDatetimeを取得します。
	 * @return insertDatetime
	 */
	public String getInsertDatetime() {
		return insertDatetime;
	}

	/**
	 * insertDatetimeを設定します。
	 * @param insertDatetime
	 */
	public void setInsertDatetime(String insertDatetime) {
		this.insertDatetime = insertDatetime;
	}

	/**
	 * insertDivを取得します。
	 * @return insertDiv
	 */
	public Integer getInsertDiv() {
		return insertDiv;
	}

	/**
	 * insertDivを設定します。
	 * @param insertDiv
	 */
	public void setInsertDiv(Integer insertDiv) {
		this.insertDiv = insertDiv;
	}

    public static Item valueOf(Map<String, Object> map) {
        Item item = new Item();

        item.itemCd = StringUtil.defaultString(map.get("item_cd"), "");
        item.itemName1 = StringUtil.defaultString(map.get("item_name1"), "");
        item.itemName2 = StringUtil.defaultString(map.get("item_name2"), "");
        item.itemNameKana = StringUtil.defaultString(map.get("item_name_kana"), "");

        if (map.get("tax_exempt_div") != null) {
            item.taxExemptDiv = StringUtil.toInteger(String.valueOf(map.get("tax_exempt_div")), 0);
        }
        if (map.get("tax_bracket_cd") != null) {
            item.taxBracketCd = StringUtil.toInteger(String.valueOf(map.get("tax_bracket_cd")), 0);
        }
        if (map.get("user_item_cd") != null) {
            item.userItemCd = StringUtil.defaultString(map.get("user_item_cd"), "");
        }
        if (map.get("user_item_name1") != null) {
            item.userItemName1 = StringUtil.defaultString(map.get("user_item_name1"), "");
        }
        if (map.get("user_item_name2") != null) {
            item.userItemName2 = StringUtil.defaultString(map.get("user_item_name2"), "");
        }

        if (map.get("quantity_per_case") != null) {
        	BigDecimal quantityPerCaseBDValue = BigDecimal.ZERO;
        	String quantityPerCaseStrValue = (String)map.get("quantity_per_case");
        	if (!StringUtils.isEmpty(quantityPerCaseStrValue)) {
        		quantityPerCaseBDValue = new BigDecimal(quantityPerCaseStrValue);
        	}
        	item.quantityPerCase = quantityPerCaseBDValue;
        }

        if (map.get("cart_disp_flg") != null) {
            item.cartDispFlg = StringUtil.toInteger(String.valueOf(map.get("cart_disp_flg")), 0);
        }
        if (map.get("item_disp_flg") != null) {
            item.itemDispFlg = StringUtil.toInteger(String.valueOf(map.get("item_disp_flg")), 0);
        }

        if (map.get("whole_sale_price") != null) {
            // item.wholeSalePrice = new BigDecimal(String.valueOf(map.get("whole_sale_price")));
        	BigDecimal wholeSalePriceBDValue = BigDecimal.ZERO;
        	String wholeSalePriceStrValue = (String)map.get("whole_sale_price");
        	if (!StringUtils.isEmpty(wholeSalePriceStrValue)) {
        		wholeSalePriceBDValue = new BigDecimal(wholeSalePriceStrValue);
        	}
        	item.wholeSalePrice = wholeSalePriceBDValue;
        }

        if (map.get("unit") != null) {
            item.unit = StringUtil.defaultString(map.get("unit"), "");
        }

        return item;
    }

    /** カートボタン表示フラグ */
    public static class CartDispFlg {
        /** 表示 */
        public static final String YES = "1";
        /** 非表示 */
        public static final String NO = "0";
        /** 条件なし */
        public static final String NOT = "9";
        /** 表示 */
        public static final String DISP = "表示";
        /** 非表示 */
        public static final String NO_DISP = "非表示";
        /** マップ */
        public static final LinkedHashMap<String, String> CART_DISP_MAP = new LinkedHashMap<String, String>();
        static {
            CART_DISP_MAP.put(YES, DISP);
            CART_DISP_MAP.put(NO, NO_DISP);
        }
        /** 表示フラグ条件マップ */
        public static final LinkedHashMap<String, String> CART_DISP_FLG_CONDITION_MAP = new LinkedHashMap<String, String>();
        static {
            CART_DISP_FLG_CONDITION_MAP.put(NOT, "条件なし");
            CART_DISP_FLG_CONDITION_MAP.put(YES, DISP);
            CART_DISP_FLG_CONDITION_MAP.put(NO, NO_DISP);
        }
    }


}
