package jp.ill.photon.model;

import java.io.File;
import java.util.Map;


public class FileForm {

    /** 連番 */
    private int recordNo;
    /** ファイル */
    private File file;
    /** 削除フラグ */
    private String delFlg;
    /** ファイル名 */
    private String fileName;

    /**
     * 連番を取得します。
     * @return 連番
     */
    public int getRecordNo() {
        return recordNo;
    }

    /**
     * 連番を設定します。
     * @param recordNo 連番
     */
    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    /**
     * ファイルを取得します。
     * @return ファイル
     */
    public File getFile() {
        return file;
    }

    /**
     * ファイルを設定します。
     * @param file ファイル
     */
    public void setFile(File file) {
        this.file = file;
    }

    /**
     * 削除フラグを取得します。
     * @return 削除フラグ
     */
    public String getDelFlg() {
        return delFlg;
    }

    /**
     * 削除フラグを設定します。
     * @param delFlg 削除フラグ
     */
    public void setDelFlg(String delFlg) {
        this.delFlg = delFlg;
    }

    /**
     * ファイル名を取得します。
     * @return ファイル名
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * ファイル名を設定します。
     * @param fileName ファイル名
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static FileForm valueOf(Map<String, Object> map) {

    	FileForm fileForm = new FileForm();

        fileForm.file = (File) map.get("file");
        fileForm.fileName = (String) map.get("fileName");
        fileForm.recordNo = (map.get("recordNo") == null)? 0 : (Integer)map.get("recordNo");
        fileForm.delFlg = (String) map.get("delFlg");

        return fileForm;

    }

}
