package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;

public class EstimateDetail implements DomainObject {

    public EstimateDetail(String estimateNo, int recordNo, CartItem cart, Item item, User user, AoSetting aoSetting, Map<String, Object> userForm) {

        this.estimateNo = estimateNo;
        this.recordNo = recordNo;

        this.userCd = user.getUserCd();

        this.itemCd = item.getItemCd();
        this.itemName1 = item.getItemName1();
        this.itemName2 = item.getItemName2();
        this.userItemCd = item.getUserItemCd();
        this.userItemName1 = item.getUserItemName1();
        this.userItemName2 = item.getUserItemName2();
        this.quantityPerCase = item.getQuantityPerCase();

        this.orderCaseQuantity = cart.getOrderCaseQuantity();
        this.orderQuantity = cart.getOrderQuantityFormat(aoSetting);
        this.wholesalePrice = cart.getWholeSalePriceFormat(aoSetting, userForm);

        this.taxExemptDiv = item.getTaxExemptDiv();
        this.taxDiv = user.getTaxDiv();
        this.taxBracketCd = item.getTaxBracketCd();
    }

    private String estimateNo;
    private int recordNo;
    private String estimateManageNo;

    private String userCd;
    private String itemCd;
    private String itemName1;
    private String itemName2;
    private String userItemCd;
    private String userItemName1;
    private String userItemName2;

    private BigDecimal quantityPerCase;
    private BigDecimal orderCaseQuantity;
    private BigDecimal orderQuantity;
    private BigDecimal wholesalePrice;

    private int taxExemptDiv;
    private int taxDiv;
    private int taxBracketCd;

    @FormProperty
    public String getEstimateNo() {
        return estimateNo;
    }
    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    @FormProperty
    public int getRecordNo() {
        return recordNo;
    }
    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    @FormProperty
    public String getEstimateManageNo() {
        return estimateManageNo;
    }
    public void setEstimateManageNo(String estimateManageNo) {
        this.estimateManageNo = estimateManageNo;
    }

    @FormProperty
    public String getUserCd() {
        return userCd;
    }
    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    @FormProperty
    public String getItemCd() {
        return itemCd;
    }
    public void setItemCd(String itemCd) {
        this.itemCd = itemCd;
    }

    @FormProperty
    public String getItemName1() {
        return itemName1;
    }
    public void setItemName1(String itemName1) {
        this.itemName1 = itemName1;
    }

    @FormProperty
    public String getItemName2() {
        return itemName2;
    }
    public void setItemName2(String itemName2) {
        this.itemName2 = itemName2;
    }

    @FormProperty
    public String getUserItemCd() {
        return userItemCd;
    }

    public void setUserItemCd(String userItemCd) {
        this.userItemCd = userItemCd;
    }

    @FormProperty
    public String getUserItemName1() {
        return userItemName1;
    }

    public void setUserItemName1(String userItemName1) {
        this.userItemName1 = userItemName1;
    }

    @FormProperty
    public String getUserItemName2() {
        return userItemName2;
    }

    public void setUserItemName2(String userItemName2) {
        this.userItemName2 = userItemName2;
    }


    @FormProperty
    public BigDecimal getQuantityPerCase() {
        return quantityPerCase;
    }
    public void setQuantityPerCase(BigDecimal quantityPerCase) {
        this.quantityPerCase = quantityPerCase;
    }

    @FormProperty
    public BigDecimal getOrderCaseQuantity() {
        return orderCaseQuantity;
    }
    public void setOrderCaseQuantity(BigDecimal orderCaseQuantity) {
        this.orderCaseQuantity = orderCaseQuantity;
    }

    @FormProperty
    public BigDecimal getOrderQuantity() {
        return orderQuantity;
    }
    public void setOrderQuantity(BigDecimal orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    @FormProperty
    public BigDecimal getWholesalePrice() {
        return wholesalePrice;
    }
    public void setWholesalePrice(BigDecimal wholesalePrice) {
        this.wholesalePrice = wholesalePrice;
    }

    @FormProperty
    public int getTaxExemptDiv() {
        return taxExemptDiv;
    }
    public void setTaxExemptDiv(int taxExemptDiv) {
        this.taxExemptDiv = taxExemptDiv;
    }

    @FormProperty
    public int getTaxDiv() {
        return taxDiv;
    }
    public void setTaxDiv(int taxDiv) {
        this.taxDiv = taxDiv;
    }

    @FormProperty
    public int getTaxBracketCd() {
        return taxBracketCd;
    }
    public void setTaxBracketCd(int taxBracketCd) {
        this.taxBracketCd = taxBracketCd;
    }

}
