package jp.ill.photon.model;

import java.math.BigDecimal;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.FormProperty;

public class Estimate implements DomainObject {

    private String estimateNo;

    private String estimateDate;

    private BigDecimal wholeSalePrice;

    private BigDecimal totalOrderQuantity;

    private String userCd;

    private String userDeliveryCd;

    private String userDeliveryName1;

    private String userDeliveryName2;

    private String zip;

    private String cityName1;

    private String cityName2;

    private String cityName3;

    private String tel;

    private String fax;

    private String chumonFlg;

    private String estimateEndTime;

    private String estimateMakeUserChargeId;

    public void setDelivery(Delivery delivery) {
        this.userDeliveryCd = delivery.getUserDeliveryCd();
        this.userDeliveryName1 = delivery.getUserDeliveryName1();
        this.userDeliveryName2 = delivery.getUserDeliveryName2();
        this.zip = delivery.getZip();
        this.cityName1 = delivery.getCityName1();
        this.cityName2 = delivery.getCityName2();
        this.cityName3 = delivery.getCityName3();
        this.tel = delivery.getTel();
        this.fax = delivery.getFax();
    }

    @DefaultParamSetting(transferType = "param_multi", transferVal = "order.cart_id")
    private String[] cartId;

    @DefaultParamSetting(transferType = "param_multi", transferVal = "order.quantity")
    private String[] quantity;

    @DefaultParamSetting(transferType = "param_multi", transferVal = "order.case_quantity")
    private String[] caseQuantity;

    @DefaultParamSetting(transferType = "param", transferVal = "order.remarks")
    private String remarks;

    public String getDeliveryFeeCd() {
		return deliveryFeeCd;
	}

	public void setDeliveryFeeCd(String deliveryFeeCd) {
		this.deliveryFeeCd = deliveryFeeCd;
	}

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @DefaultParamSetting(transferType = "param", transferVal = "order.area_name")
    private String areaName;

    @DefaultParamSetting(transferType = "param", transferVal = "order.delivery_fee_cd")
	private String deliveryFeeCd;

    @FormProperty
    public String getEstimateNo() {
        return estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    @FormProperty
    public String getEstimateDate() {
        return estimateDate;
    }

    public void setEstimateDate(String estimateDate) {
        this.estimateDate = estimateDate;
    }

    @FormProperty
    public BigDecimal getWholesalePrice() {
        return wholeSalePrice;
    }

    public void setWholesalePrice(BigDecimal wholeSalePrice) {
        this.wholeSalePrice = wholeSalePrice;
    }

    @FormProperty
    public BigDecimal getTotalOrderQuantity() {
        return totalOrderQuantity;
    }

    public void setTotalOrderQuantity(BigDecimal totalOrderQuantity) {
        this.totalOrderQuantity = totalOrderQuantity;
    }

    @FormProperty
    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    @FormProperty
    public String getUserDeliveryCd() {
        return userDeliveryCd;
    }

    public void setUserDeliveryCd(String userDeliveryCd) {
        this.userDeliveryCd = userDeliveryCd;
    }

    @FormProperty
    public String getUserDeliveryName1() {
        return userDeliveryName1;
    }

    public void setUserDeliveryName1(String userDeliveryName1) {
        this.userDeliveryName1 = userDeliveryName1;
    }

    @FormProperty
    public String getUserDeliveryName2() {
        return userDeliveryName2;
    }

    public void setUserDeliveryName2(String userDeliveryName2) {
        this.userDeliveryName2 = userDeliveryName2;
    }

    @FormProperty
    public String getZip() {
        return zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    //@FormProperty
    public String getCityName1() {
        return cityName1;
    }

    public void setCityName1(String cityName1) {
        this.cityName1 = cityName1;
    }

    //@FormProperty
    public String getCityName2() {
        return cityName2;
    }

    public void setCityName2(String cityName2) {
        this.cityName2 = cityName2;
    }

    //@FormProperty
    public String getCityName3() {
        return cityName3;
    }

    public void setCityName3(String cityName3) {
        this.cityName3 = cityName3;
    }

    @FormProperty
    public String getCityName_1() {
        return cityName1;
    }

    @FormProperty
    public String getCityName_2() {
        return cityName2;
    }

    @FormProperty
    public String getCityName_3() {
        return cityName3;
    }

    @FormProperty
    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    @FormProperty
    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @FormProperty
    public String getChumonFlg() {
        return chumonFlg;
    }

    public void setChumonFlg(String chumonFlg) {
        this.chumonFlg = chumonFlg;
    }

    @FormProperty
    public String getEstimateEndTime() {
        return estimateEndTime;
    }

    public void setEstimateEndTime(String estimateEndTime) {
        this.estimateEndTime = estimateEndTime;
    }

    @FormProperty
    public String getEstimateMakeUserChargeId() {
        return estimateMakeUserChargeId;
    }

    public void setEstimateMakeUserChargeId(String estimateMakeUserChargeId) {
        this.estimateMakeUserChargeId = estimateMakeUserChargeId;
    }

    public String[] getCartId() {
        return cartId;
    }

    public void setCartId(String[] cartId) {
        this.cartId = cartId;
    }

    public String[] getQuantity() {
        return quantity;
    }

    public void setQuantity(String[] quantity) {
        this.quantity = quantity;
    }

    public String[] getCaseQuantity() {
        return caseQuantity;
    }

    public void setCaseQuantity(String[] caseQuantity) {
        this.caseQuantity = caseQuantity;
    }

    @FormProperty
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

}
