package jp.ill.photon.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.ParamUtil;

public interface DomainObject {
    default Map<String, Object> toMap() {
        Map<String, Object> result = new HashMap<String, Object>();

        Method[] ms = this.getClass().getDeclaredMethods();
        for (Method m : ms) {

            try {
                FormProperty form = m.getAnnotation(FormProperty.class);

                if (form != null) {
                    String methodName = m.getName();
                    // getを除く
                    String propNameCamel = methodName.substring(3);
                    String propNameSnake = ParamUtil.camelToSnake(propNameCamel);

                    result.put(propNameSnake, m.invoke(this, null));
                }
            } catch (InvocationTargetException ex) {
                ex.printStackTrace();
            } catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        return result;
    }
}
