package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;

public class DeliveryFee implements DomainObject {

    private String deliveryFeeCd;

    private String recordNo;

    private String areaName;

    private BigDecimal deliveryCharge;

    private String address;

    private String prioryNo;

    @FormProperty
    public String getDeliveryFeeCd() {
        return deliveryFeeCd;
    }

    public void setDeliveryFeeCd(String deliveryFeeCd) {
        this.deliveryFeeCd = deliveryFeeCd;
    }

    @FormProperty
    public String getRecordNo() {
        return recordNo;
    }

    public void setRecordNo(String recordNo) {
        this.recordNo = recordNo;
    }

    @FormProperty
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @FormProperty
    public BigDecimal getDeliveryCharge() {
        return deliveryCharge;
    }

    public void setDeliveryCharge(BigDecimal deliveryCharge) {
        this.deliveryCharge = deliveryCharge;
    }

    @FormProperty
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @FormProperty
    public String getPrioryNo() {
        return prioryNo;
    }

    public void setPrioryNo(String prioryNo) {
        this.prioryNo = prioryNo;
    }

    public static DeliveryFee valueOf(Map<String, Object> map) {
        DeliveryFee deliveryFee = new DeliveryFee();

        deliveryFee.deliveryFeeCd = String.valueOf(map.get("delivery_fee_cd"));
        deliveryFee.recordNo = String.valueOf(map.get("record_no"));
        deliveryFee.areaName = String.valueOf(map.get("area_name"));
        deliveryFee.deliveryCharge = StringUtil.toBigDecimal(String.valueOf(map.get("delivery_charge")), new BigDecimal(0.0));
        deliveryFee.address = String.valueOf(map.get("address"));
        deliveryFee.prioryNo = String.valueOf(map.get("priory_no"));

        return deliveryFee;
    }

}
