package jp.ill.photon.model;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.dao.builder.JSONDomaSQLQueryBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.util.StringUtil;

public class Delivery implements DomainObject {

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.user_delivery_cd")
    private String userDeliveryCd;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.user_delivery_name1")
    private String userDeliveryName1;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.user_delivery_name2")
    private String userDeliveryName2;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.zip")
    private String zip;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.city_name1")
    private String cityName1;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.city_name2")
    private String cityName2;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.city_name3")
    private String cityName3;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.tel")
    private String tel;

    @DefaultParamSetting(transferType = "param", transferVal = "delivery.fax")
    private String fax;

    private String userCd;
    private String chargeName;

    private String updateUserName;
    private String updateDatetime;
    private Integer updateDiv;
    private String insertUserName;
    private String insertDatetime;
    private Integer insertDiv;

    @FormProperty
    public String getUserDeliveryCd() {
        return userDeliveryCd;
    }

    public void setUserDeliveryCd(String userDeliveryCd) {
        this.userDeliveryCd = userDeliveryCd;
    }

    @FormProperty
    public String getUserDeliveryName() {
        String name1 = userDeliveryName1 == null ? "" : userDeliveryName1;
        String name2 = userDeliveryName2 == null ? "" : userDeliveryName2;

        return name1 + name2;
    }

    @FormProperty
    public String getUserDeliveryName1() {
        return userDeliveryName1;
    }

    public void setUserDeliveryName1(String userDeliveryName1) {
        this.userDeliveryName1 = userDeliveryName1;
    }

    @FormProperty
    public String getUserDeliveryName2() {
        return userDeliveryName2;
    }

    public void setUserDeliveryName2(String userDeliveryName2) {
        this.userDeliveryName2 = userDeliveryName2;
    }

    @FormProperty
    public String getZip() {
        return zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @FormProperty
    public String getCityName() {
        String name1 = cityName1 == null ? "" : cityName1;
        String name2 = cityName2 == null ? "" : cityName2;
        String name3 = cityName3 == null ? "" : cityName3;

        return name1 + name2 + name3;
    }

    @FormProperty
    public String getCityName_1() {
        return cityName1;
    }

    @FormProperty
    public String getCityName_2() {
        return cityName2;
    }

    @FormProperty
    public String getCityName_3() {
        return cityName3;
    }

    public String getCityName1() {
        return cityName1;
    }

    public void setCityName1(String cityName1) {
        this.cityName1 = cityName1;
    }

    public String getCityName2() {
        return cityName2;
    }

    public void setCityName2(String cityName2) {
        this.cityName2 = cityName2;
    }

    public String getCityName3() {
        return cityName3;
    }

    public void setCityName3(String cityName3) {
        this.cityName3 = cityName3;
    }

    @FormProperty
    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    @FormProperty
    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

	public String getUserCd() {
		return userCd;
	}

	public void setUserCd(String userCd) {
		this.userCd = userCd;
	}

	public String getChargeName() {
		return chargeName;
	}

	public void setChargeName(String chargeName) {
		this.chargeName = chargeName;
	}

	public String getUpdateUserName() {
		return updateUserName;
	}

	public void setUpdateUserName(String updateUserName) {
		this.updateUserName = updateUserName;
	}

	public String getUpdateDatetime() {
		return updateDatetime;
	}

	public void setUpdateDatetime(String updateDatetime) {
		this.updateDatetime = updateDatetime;
	}

	public Integer getUpdateDiv() {
		return updateDiv;
	}

	public void setUpdateDiv(Integer updateDiv) {
		this.updateDiv = updateDiv;
	}

	public String getInsertUserName() {
		return insertUserName;
	}

	public void setInsertUserName(String insertUserName) {
		this.insertUserName = insertUserName;
	}

	public String getInsertDatetime() {
		return insertDatetime;
	}

	public void setInsertDatetime(String insertDatetime) {
		this.insertDatetime = insertDatetime;
	}

	public Integer getInsertDiv() {
		return insertDiv;
	}

	public void setInsertDiv(Integer insertDiv) {
		this.insertDiv = insertDiv;
	}

    public static Delivery valueOf(Map<String, Object> map) {
        if (map == null) {
            return null;
        }

        Delivery delivery = new Delivery();

        delivery.userDeliveryCd = StringUtil.defaultString(map.get("user_delivery_cd"), "");
        delivery.userDeliveryName1 = StringUtil.defaultString(map.get("user_delivery_name1"), "");
        delivery.userDeliveryName2 = StringUtil.defaultString(map.get("user_delivery_name2"), "");
        delivery.zip = StringUtil.defaultString(map.get("zip"), "");
        delivery.cityName1 = (map.get("city_name1") != null) ? StringUtil.defaultString(map.get("city_name1"), "") : StringUtil.defaultString(map.get("city_name_1"), "");
        delivery.cityName2 = (map.get("city_name2") != null) ? StringUtil.defaultString(map.get("city_name2"), "") : StringUtil.defaultString(map.get("city_name_2"), "");
        delivery.cityName3 = (map.get("city_name3") != null) ? StringUtil.defaultString(map.get("city_name3"), "") : StringUtil.defaultString(map.get("city_name_3"), "");
        delivery.tel = StringUtil.defaultString(map.get("tel"), "");
        delivery.fax = StringUtil.defaultString(map.get("fax"), "");

        return delivery;
    }

    public static Delivery getDelivery(ActionDto dto, String userDeliveryCd) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("tbu.val ");
        query.append("FROM entity_data tbu ");
        query.append("WHERE tbu.tenant_id = {#tenant_id, text, action#} ");
        query.append("AND tbu.edit_table_cd = 'userdelivery' ");
        query.append("AND tbu.val->>'user_delivery_cd' = {#user_delivery_cd, text, param#} ");
        query.append("AND tbu.is_deleted = {#0, int#} ");

        Map<String, Object> params = new HashMap<>();
        params.put("user_delivery_cd", userDeliveryCd);

        JSONDomaSQLQueryBuilder queryBuilder = new JSONDomaSQLQueryBuilder();
        Map<String, Object> deliveryMap = queryBuilder.getFirstResult(query.toString(),
                params, dto);
        return valueOf(deliveryMap);
    }

}
