package jp.ill.photon.model;

import java.util.Map;

import jp.ill.photon.util.StringUtil;

public class CreditPayment {

    private String paymentMethodCd;

    private String paymentMethodName;

    private Integer sortNo;

    public String getPaymentMethodCd() {
        return paymentMethodCd;
    }

    public void setPaymentMethodCd(String paymentMethodCd) {
        this.paymentMethodCd = paymentMethodCd;
    }

    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public static CreditPayment valueOf(Map<String, Object> map) {
        CreditPayment payment = new CreditPayment();

        payment.paymentMethodCd = String.valueOf(map.get("payment_method_cd"));
        payment.paymentMethodName = String.valueOf(map.get("payment_method_name"));
        payment.sortNo = StringUtil.toInteger(String.valueOf(map.get("sort_no")), 0);

        return payment;
    }

}
