package jp.ill.photon.model;

import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;

public class ConveniencePayment implements DomainObject {

    private String paymentMethodCd;

    private String paymentMethodName;

    private Integer sortNo;

    @FormProperty
    public String getPaymentMethodCd() {
        return paymentMethodCd;
    }

    public void setPaymentMethodCd(String paymentMethodCd) {
        this.paymentMethodCd = paymentMethodCd;
    }

    @FormProperty
    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public static ConveniencePayment valueOf(Map<String, Object> map) {
        ConveniencePayment payment = new ConveniencePayment();

        payment.paymentMethodCd = String.valueOf(map.get("payment_method_cd"));
        payment.paymentMethodName = String.valueOf(map.get("payment_method_name"));
        payment.sortNo = StringUtil.toInteger(String.valueOf(map.get("sort_no")), 0);

        return payment;
    }
}
