package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.util.StringUtil;

public class ChargeFee {

    private String paymentCd;
    private String sortNo;
    private BigDecimal threshold;
    private BigDecimal fee;

    public String getPaymentCd() {
        return paymentCd;
    }
    public void setPaymentCd(String paymentCd) {
        this.paymentCd = paymentCd;
    }
    public String getSortNo() {
        return sortNo;
    }
    public void setSortNo(String sortNo) {
        this.sortNo = sortNo;
    }
    public BigDecimal getThreshold() {
        return threshold;
    }
    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }
    public BigDecimal getFee() {
        return fee;
    }
    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public static ChargeFee valueOf(Map<String, Object> map) {
        ChargeFee codFee = new ChargeFee();

        codFee.paymentCd = String.valueOf(map.get("payment_cd"));
        codFee.sortNo = String.valueOf(map.get("sort_no"));
        codFee.threshold = StringUtil.toBigDecimal(String.valueOf(map.get("threshold")), new BigDecimal(0.0));
        codFee.fee = StringUtil.toBigDecimal(String.valueOf(map.get("fee")), new BigDecimal(0.0));

        return codFee;
    }

}
