package jp.ill.photon.model;

import java.util.LinkedHashMap;
import java.util.Map;

public class CharacterConst {
    /* Aladdin-EC 3rdリリース #6530 START */
    /** 文字コード定義クラス */
    // Rev.112>>>
    public static class CharacterCd {

        /** UTF-8 */
        public static final String UTF8 = "UTF-8";
        /** Shift_JIS */
        public static final String SJIS = "Windows-31J";
        /** EUC-JP */
        public static final String EUCJP = "EUC-JP";

        /** 文字コードのマップ */
        public static final Map<String, String> CHARACTER_CD_MAP = new LinkedHashMap<String, String>();
        static {
            CHARACTER_CD_MAP.put(UTF8, UTF8);
            CHARACTER_CD_MAP.put(SJIS, "SJIS");
            CHARACTER_CD_MAP.put(EUCJP, EUCJP);
        }
    }

    /** 文字列変換 */
    public static class TextConvert {

        /** 文字列変換用テーブル */
        public static final String HALF_NUM = "0123456789";
        public static final String HALF_ALPHA_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        public static final String HALF_ALPHA_LOWER = "abcdefghijklmnopqrstuvwxyz";
        public static final String HALF_KANA_KIGOU = "ﾞﾟ";
        public static final String HALF_KANA = "ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝ";
        public static final String HALF_KIGOU = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~｡｢｣､･"
                + HALF_KANA_KIGOU;

        /** 半角記号用テーブル */
        public static final LinkedHashMap<String, String> HALF_KIGOU_TABLE = new LinkedHashMap<String, String>();
        static {
            HALF_KIGOU_TABLE.put(" ", "　");
            HALF_KIGOU_TABLE.put("!", "！");
            HALF_KIGOU_TABLE.put("\"", "”");
            HALF_KIGOU_TABLE.put("#", "＃");
            HALF_KIGOU_TABLE.put("$", "＄");
            HALF_KIGOU_TABLE.put("%", "％");
            HALF_KIGOU_TABLE.put("&", "＆");
            HALF_KIGOU_TABLE.put("'", "’");
            HALF_KIGOU_TABLE.put("(", "（");
            HALF_KIGOU_TABLE.put(")", "）");
            HALF_KIGOU_TABLE.put("*", "＊");
            HALF_KIGOU_TABLE.put("+", "＋");
            HALF_KIGOU_TABLE.put(",", "，");
            HALF_KIGOU_TABLE.put("-", "－");
            HALF_KIGOU_TABLE.put(".", "．");
            HALF_KIGOU_TABLE.put("/", "／");
            HALF_KIGOU_TABLE.put(":", "：");
            HALF_KIGOU_TABLE.put(";", "；");
            HALF_KIGOU_TABLE.put("<", "＜");
            HALF_KIGOU_TABLE.put("=", "＝");
            HALF_KIGOU_TABLE.put(">", "＞");
            HALF_KIGOU_TABLE.put("?", "？");
            HALF_KIGOU_TABLE.put("@", "＠");
            HALF_KIGOU_TABLE.put("[", "［");
            HALF_KIGOU_TABLE.put("\\", "￥");
            HALF_KIGOU_TABLE.put("]", "］");
            HALF_KIGOU_TABLE.put("^", "＾");
            HALF_KIGOU_TABLE.put("_", "＿");
            HALF_KIGOU_TABLE.put("`", "｀");
            HALF_KIGOU_TABLE.put("{", "｛");
            HALF_KIGOU_TABLE.put("|", "｜");
            HALF_KIGOU_TABLE.put("}", "｝");
            HALF_KIGOU_TABLE.put("~", "￣");
            HALF_KIGOU_TABLE.put("｡", "。");
            HALF_KIGOU_TABLE.put("｢", "「");
            HALF_KIGOU_TABLE.put("｣", "」");
            HALF_KIGOU_TABLE.put("､", "、");
            HALF_KIGOU_TABLE.put("･", "・");
            HALF_KIGOU_TABLE.put("ﾞ", "゛");
            HALF_KIGOU_TABLE.put("ﾟ", "゜");
        }

        /** 半角カナ用テーブル */
        public static final LinkedHashMap<String, String> HALF_KANA_TABLE = new LinkedHashMap<String, String>();
        static {
            HALF_KANA_TABLE.put("ｦ", "ヲ");
            HALF_KANA_TABLE.put("ｧ", "ァ");
            HALF_KANA_TABLE.put("ｨ", "ィ");
            HALF_KANA_TABLE.put("ｩ", "ゥ");
            HALF_KANA_TABLE.put("ｪ", "ェ");
            HALF_KANA_TABLE.put("ｫ", "ォ");
            HALF_KANA_TABLE.put("ｬ", "ャ");
            HALF_KANA_TABLE.put("ｭ", "ュ");
            HALF_KANA_TABLE.put("ｮ", "ョ");
            HALF_KANA_TABLE.put("ｯ", "ッ");
            HALF_KANA_TABLE.put("ｰ", "ー");
            HALF_KANA_TABLE.put("ｱ", "ア");
            HALF_KANA_TABLE.put("ｲ", "イ");
            HALF_KANA_TABLE.put("ｳ", "ウ");
            HALF_KANA_TABLE.put("ｴ", "エ");
            HALF_KANA_TABLE.put("ｵ", "オ");
            HALF_KANA_TABLE.put("ｶ", "カ");
            HALF_KANA_TABLE.put("ｷ", "キ");
            HALF_KANA_TABLE.put("ｸ", "ク");
            HALF_KANA_TABLE.put("ｹ", "ケ");
            HALF_KANA_TABLE.put("ｺ", "コ");
            HALF_KANA_TABLE.put("ｻ", "サ");
            HALF_KANA_TABLE.put("ｼ", "シ");
            HALF_KANA_TABLE.put("ｽ", "ス");
            HALF_KANA_TABLE.put("ｾ", "セ");
            HALF_KANA_TABLE.put("ｿ", "ソ");
            HALF_KANA_TABLE.put("ﾀ", "タ");
            HALF_KANA_TABLE.put("ﾁ", "チ");
            HALF_KANA_TABLE.put("ﾂ", "ツ");
            HALF_KANA_TABLE.put("ﾃ", "テ");
            HALF_KANA_TABLE.put("ﾄ", "ト");
            HALF_KANA_TABLE.put("ﾅ", "ナ");
            HALF_KANA_TABLE.put("ﾆ", "ニ");
            HALF_KANA_TABLE.put("ﾇ", "ヌ");
            HALF_KANA_TABLE.put("ﾈ", "ネ");
            HALF_KANA_TABLE.put("ﾉ", "ノ");
            HALF_KANA_TABLE.put("ﾊ", "ハ");
            HALF_KANA_TABLE.put("ﾋ", "ヒ");
            HALF_KANA_TABLE.put("ﾌ", "フ");
            HALF_KANA_TABLE.put("ﾍ", "ヘ");
            HALF_KANA_TABLE.put("ﾎ", "ホ");
            HALF_KANA_TABLE.put("ﾏ", "マ");
            HALF_KANA_TABLE.put("ﾐ", "ミ");
            HALF_KANA_TABLE.put("ﾑ", "ム");
            HALF_KANA_TABLE.put("ﾒ", "メ");
            HALF_KANA_TABLE.put("ﾓ", "モ");
            HALF_KANA_TABLE.put("ﾔ", "ヤ");
            HALF_KANA_TABLE.put("ﾕ", "ユ");
            HALF_KANA_TABLE.put("ﾖ", "ヨ");
            HALF_KANA_TABLE.put("ﾗ", "ラ");
            HALF_KANA_TABLE.put("ﾘ", "リ");
            HALF_KANA_TABLE.put("ﾙ", "ル");
            HALF_KANA_TABLE.put("ﾚ", "レ");
            HALF_KANA_TABLE.put("ﾛ", "ロ");
            HALF_KANA_TABLE.put("ﾜ", "ワ");
            HALF_KANA_TABLE.put("ﾝ", "ン");
        }

        /** 半角カナ 濁音、半濁音用テーブル */
        public static final LinkedHashMap<String, String> HALF_KANA_DAKUON_TABLE = new LinkedHashMap<String, String>();
        static {
            HALF_KANA_DAKUON_TABLE.put("ｳﾞ", "ヴ");
            HALF_KANA_DAKUON_TABLE.put("ｶﾞ", "ガ");
            HALF_KANA_DAKUON_TABLE.put("ｷﾞ", "ギ");
            HALF_KANA_DAKUON_TABLE.put("ｸﾞ", "グ");
            HALF_KANA_DAKUON_TABLE.put("ｹﾞ", "ゲ");
            HALF_KANA_DAKUON_TABLE.put("ｺﾞ", "ゴ");
            HALF_KANA_DAKUON_TABLE.put("ｻﾞ", "ザ");
            HALF_KANA_DAKUON_TABLE.put("ｼﾞ", "ジ");
            HALF_KANA_DAKUON_TABLE.put("ｽﾞ", "ズ");
            HALF_KANA_DAKUON_TABLE.put("ｾﾞ", "ゼ");
            HALF_KANA_DAKUON_TABLE.put("ｿﾞ", "ゾ");
            HALF_KANA_DAKUON_TABLE.put("ﾀﾞ", "ダ");
            HALF_KANA_DAKUON_TABLE.put("ﾁﾞ", "ヂ");
            HALF_KANA_DAKUON_TABLE.put("ﾂﾞ", "ヅ");
            HALF_KANA_DAKUON_TABLE.put("ﾃﾞ", "デ");
            HALF_KANA_DAKUON_TABLE.put("ﾄﾞ", "ド");
            HALF_KANA_DAKUON_TABLE.put("ﾊﾞ", "バ");
            HALF_KANA_DAKUON_TABLE.put("ﾋﾞ", "ビ");
            HALF_KANA_DAKUON_TABLE.put("ﾌﾞ", "ブ");
            HALF_KANA_DAKUON_TABLE.put("ﾍﾞ", "ベ");
            HALF_KANA_DAKUON_TABLE.put("ﾎﾞ", "ボ");
            HALF_KANA_DAKUON_TABLE.put("ﾊﾟ", "パ");
            HALF_KANA_DAKUON_TABLE.put("ﾋﾟ", "ピ");
            HALF_KANA_DAKUON_TABLE.put("ﾌﾟ", "プ");
            HALF_KANA_DAKUON_TABLE.put("ﾍﾟ", "ペ");
            HALF_KANA_DAKUON_TABLE.put("ﾎﾟ", "ポ");
        }
        /* Aladdin-EC 3rdリリース #8316 Rev.41>>> */
        /** 半角カナ用テーブル(SF) */
        public static final LinkedHashMap<String, String> HALF_KANA_TABLE_SF = new LinkedHashMap<String, String>();
        static {
            HALF_KANA_TABLE_SF.putAll(HALF_KANA_TABLE);
            HALF_KANA_TABLE_SF.put("ﾞ", "゛");
            HALF_KANA_TABLE_SF.put("ﾟ", "゜");
            HALF_KANA_TABLE_SF.put("｡", "。");
            HALF_KANA_TABLE_SF.put("｢", "「");
            HALF_KANA_TABLE_SF.put("｣", "」");
            HALF_KANA_TABLE_SF.put("､", "、");
            HALF_KANA_TABLE_SF.put("･", "・");
        }
        /** 全角用テーブル(SF) */
        public static final LinkedHashMap<String, String> FULL_KANA_TABLE_SF = new LinkedHashMap<String, String>();
        static {
            FULL_KANA_TABLE_SF.put("－", "-");
            FULL_KANA_TABLE_SF.put("０", "0");
            FULL_KANA_TABLE_SF.put("１", "1");
            FULL_KANA_TABLE_SF.put("２", "2");
            FULL_KANA_TABLE_SF.put("３", "3");
            FULL_KANA_TABLE_SF.put("４", "4");
            FULL_KANA_TABLE_SF.put("５", "5");
            FULL_KANA_TABLE_SF.put("６", "6");
            FULL_KANA_TABLE_SF.put("７", "7");
            FULL_KANA_TABLE_SF.put("８", "8");
            FULL_KANA_TABLE_SF.put("９", "9");
            FULL_KANA_TABLE_SF.put("Ａ", "A");
            FULL_KANA_TABLE_SF.put("Ｂ", "B");
            FULL_KANA_TABLE_SF.put("Ｃ", "C");
            FULL_KANA_TABLE_SF.put("Ｄ", "D");
            FULL_KANA_TABLE_SF.put("Ｅ", "E");
            FULL_KANA_TABLE_SF.put("Ｆ", "F");
            FULL_KANA_TABLE_SF.put("Ｇ", "G");
            FULL_KANA_TABLE_SF.put("Ｈ", "H");
            FULL_KANA_TABLE_SF.put("Ｉ", "I");
            FULL_KANA_TABLE_SF.put("Ｊ", "J");
            FULL_KANA_TABLE_SF.put("Ｋ", "K");
            FULL_KANA_TABLE_SF.put("Ｌ", "L");
            FULL_KANA_TABLE_SF.put("Ｍ", "M");
            FULL_KANA_TABLE_SF.put("Ｎ", "N");
            FULL_KANA_TABLE_SF.put("Ｏ", "O");
            FULL_KANA_TABLE_SF.put("Ｐ", "P");
            FULL_KANA_TABLE_SF.put("Ｑ", "Q");
            FULL_KANA_TABLE_SF.put("Ｒ", "R");
            FULL_KANA_TABLE_SF.put("Ｓ", "S");
            FULL_KANA_TABLE_SF.put("Ｔ", "T");
            FULL_KANA_TABLE_SF.put("Ｕ", "U");
            FULL_KANA_TABLE_SF.put("Ｖ", "V");
            FULL_KANA_TABLE_SF.put("Ｗ", "W");
            FULL_KANA_TABLE_SF.put("Ｘ", "X");
            FULL_KANA_TABLE_SF.put("Ｙ", "Y");
            FULL_KANA_TABLE_SF.put("Ｚ", "Z");
            FULL_KANA_TABLE_SF.put("　", " ");
            FULL_KANA_TABLE_SF.put("ａ", "A");
            FULL_KANA_TABLE_SF.put("ｂ", "B");
            FULL_KANA_TABLE_SF.put("ｃ", "C");
            FULL_KANA_TABLE_SF.put("ｄ", "D");
            FULL_KANA_TABLE_SF.put("ｅ", "E");
            FULL_KANA_TABLE_SF.put("ｆ", "F");
            FULL_KANA_TABLE_SF.put("ｇ", "G");
            FULL_KANA_TABLE_SF.put("ｈ", "H");
            FULL_KANA_TABLE_SF.put("ｉ", "I");
            FULL_KANA_TABLE_SF.put("ｊ", "J");
            FULL_KANA_TABLE_SF.put("ｋ", "K");
            FULL_KANA_TABLE_SF.put("ｌ", "L");
            FULL_KANA_TABLE_SF.put("ｍ", "M");
            FULL_KANA_TABLE_SF.put("ｎ", "N");
            FULL_KANA_TABLE_SF.put("ｏ", "O");
            FULL_KANA_TABLE_SF.put("ｐ", "P");
            FULL_KANA_TABLE_SF.put("ｑ", "Q");
            FULL_KANA_TABLE_SF.put("ｒ", "R");
            FULL_KANA_TABLE_SF.put("ｓ", "S");
            FULL_KANA_TABLE_SF.put("ｔ", "T");
            FULL_KANA_TABLE_SF.put("ｕ", "U");
            FULL_KANA_TABLE_SF.put("ｖ", "V");
            FULL_KANA_TABLE_SF.put("ｗ", "W");
            FULL_KANA_TABLE_SF.put("ｘ", "X");
            FULL_KANA_TABLE_SF.put("ｙ", "Y");
            FULL_KANA_TABLE_SF.put("ｚ", "Z");
        }
        /* Aladdin-EC 3rdリリース #8316 <<<Rev.41 */
    }

}
