package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.AoUtil.FractionDiv;
import jp.ill.photon.util.StringUtil;

public class CartItem implements DomainObject {

	private Integer cartId;
	private String itemCd;

	private BigDecimal retailPrice;
	private BigDecimal wholesalePrice;
	private String unit;
	private String itemImage1;
	private String itemImage2;

	private BigDecimal orderQuantity;
	private BigDecimal orderCaseQuantity;
	private BigDecimal quantityPerCase;

	private BigDecimal taxPrice;
	private Double taxRate;

	private String itemName1;
	private String itemName2;
	private String itemName;

	private String itemCategoryName1;
	private String itemCategoryName2;
	private String itemCategoryName3;
	private String itemCategoryName4;
	private String itemCategoryName5;
	private String itemCategoryName6;
	private String itemCategoryName7;
	private String itemCategoryName8;
	private String itemCategoryName9;
	private String itemCategoryName10;

	private String remarks1;
	private String remarks2;
	private String remarks3;
	private String remarks4;
	private String remarks5;
	private String remarks6;
	private String remarks7;
	private String remarks8;
	private String remarks9;
	private String remarks10;
	private String remarks11;

	private String userItemCd;
	private String userItemName;
	private String userItemName1;
	private String userItemName2;

	private boolean isDisplay = true;

	private String userCd;

	private String userChargeId;

	// 注文更新の時
	private String orderNo;
	private String recordNo;

	private String stockManageDiv;



	@FormProperty
	public String getStockManageDiv() {
		return stockManageDiv;
	}

	public void setStockManageDiv(String stockManageDiv) {
		this.stockManageDiv = stockManageDiv;
	}

	@FormProperty
	public String getItemImage2() {
        return itemImage2;
    }

    public void setItemImage2(String itemImage2) {
        this.itemImage2 = itemImage2;
    }

    @FormProperty
	public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @FormProperty
    public String getRecordNo() {
        return recordNo;
    }

    public void setRecordNo(String recordNo) {
        this.recordNo = recordNo;
    }

    @FormProperty
	public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    @FormProperty
    public String getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(String userChargeId) {
        this.userChargeId = userChargeId;
    }

    @FormProperty
	public boolean getIsDisplay() {
        return isDisplay;
    }

    public void setIsDisplay(boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public static BigDecimal getOrderQuantityFormat(BigDecimal quantity, AoSetting setting) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesQuantity(StringUtil.defaultString( quantity, "0.0"), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getSalesQuantityDigitNum(), setting.getSalesQuantityDecimalPointNum(), setting.getSalesQuantityRoundingDiv()));
	}

    public BigDecimal getOrderQuantityFormat(AoSetting setting) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesQuantity(orderQuantity.toString(), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getSalesQuantityDigitNum(), setting.getSalesQuantityDecimalPointNum(), setting.getSalesQuantityRoundingDiv()));
	}

    public static BigDecimal getOrderCaseQuantityFormat(BigDecimal quantity, AoSetting setting) {
	    return new BigDecimal(AoUtil.convAoRoundingCaseQuantity(StringUtil.defaultString( quantity, "0.0"), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getCaseQuantityDigitNum(), setting.getCaseQuantityDecimalPointNum(), setting.getCaseQuantityRoundingDiv()));
	}

	public BigDecimal getOrderCaseQuantityFormat(AoSetting setting) {
	    return new BigDecimal(AoUtil.convAoRoundingCaseQuantity(orderCaseQuantity.toString(), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getCaseQuantityDigitNum(), setting.getCaseQuantityDecimalPointNum(), setting.getCaseQuantityRoundingDiv()));
	}

	public BigDecimal getQuantityPerCaseFormat(AoSetting setting) {
	    return new BigDecimal(AoUtil.convAoRoundingUnitQuantity(quantityPerCase.toString(), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getUnitQuantityDigitNum(), setting.getUnitQuantityDecimalPointNum(),FractionDiv.DOWN));
	}

	public BigDecimal getRetailPriceFormat(AoSetting setting, Map<String, Object> userForm) {
		return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(retailPrice.toString(),
		        AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
		        setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
	}

	public BigDecimal getWholeSalePriceFormat(AoSetting setting, Map<String, Object> userForm) {
        return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(wholesalePrice.toString(),
                AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
                setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
    }


	public BigDecimal getRetailSalesPriceFormat(AoSetting setting, Map<String, Object> userForm) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesPrice(getRetailPriceFormat(setting, userForm).toString()
	            , orderQuantity.toString(), AoUtil.DispPattern.PATTERN_NO_COMMA,
	            setting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
	}


	public BigDecimal getSubTotalPriceFormat(AoSetting setting, Map<String, Object> userForm) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesPrice(getWholeSalePriceFormat(setting, userForm).toString()
	            , orderQuantity.toString(), AoUtil.DispPattern.PATTERN_NO_COMMA,
                setting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));
	}


	// 以下、static版

	public static BigDecimal getOrderCaseQuantityFormat(AoSetting setting, Map<String, Object> detail) {
        return new BigDecimal(AoUtil.convAoRoundingCaseQuantity(String.valueOf(detail.get("order_case_quantity")), AoUtil.DispPattern.PATTERN_NO_COMMA,
                setting.getCaseQuantityDigitNum(), setting.getCaseQuantityDecimalPointNum(), setting.getCaseQuantityRoundingDiv()));
    }

	public static BigDecimal getOrderQuantityFormat(AoSetting setting, Map<String, Object> detail) {
        return new BigDecimal(AoUtil.convAoRoundingCaseQuantity(String.valueOf(detail.get("order_quantity")), AoUtil.DispPattern.PATTERN_NO_COMMA,
                setting.getSalesQuantityDigitNum(), setting.getSalesQuantityDecimalPointNum(), setting.getSalesQuantityRoundingDiv()));
    }

	public static BigDecimal getWholeSalePriceFormat(AoSetting setting, Map<String, Object> detail, Map<String, Object> userForm ) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(String.valueOf(detail.get("wholesale_price")),
                AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
                setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
    }

	public static BigDecimal getWholeSalePriceFormat(AoSetting setting, BigDecimal price, Map<String, Object> userForm ) {
	    return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(StringUtil.defaultString(price, "0.0"),
                AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
                setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
    }

    public static BigDecimal getRetailPriceFormat(AoSetting setting, Map<String, Object> detail, Map<String, Object> userForm) {
        return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(String.valueOf(detail.get("retail_price")),
                AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
                setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
    }

    public static BigDecimal getRetailPriceFormat(AoSetting setting, BigDecimal price, Map<String, Object> userForm) {
        return new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(StringUtil.defaultString(price, "0.0"),
                AoUtil.DispPattern.PATTERN_NO_COMMA, setting.getSalesUnitPriceDigitNum(),
                setting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
    }

	public static BigDecimal getSubTotalPriceFormat(AoSetting aoSetting, Map<String, Object> detail, Map<String, Object> userForm) {
	    BigDecimal wholeSalePrice = new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(String.valueOf(detail.get("wholesale_price")),
                AoUtil.DispPattern.PATTERN_NO_COMMA, aoSetting.getSalesUnitPriceDigitNum(),
                aoSetting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
        BigDecimal subTotalPrice = new BigDecimal(AoUtil.convAoRoundingSalesPrice(wholeSalePrice.toString()
                , String.valueOf(detail.get("order_quantity")), AoUtil.DispPattern.PATTERN_NO_COMMA,
                aoSetting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));

        return subTotalPrice;
	}

	public static BigDecimal getRetailSalesPriceFormat(AoSetting aoSetting, Map<String, Object> userForm, Map<String, Object> detail) {
        BigDecimal retailPrice = new BigDecimal(AoUtil.convAoRoundingSalesUnitPrice(String.valueOf(detail.get("retail_price")),
                AoUtil.DispPattern.PATTERN_NO_COMMA, aoSetting.getSalesUnitPriceDigitNum(),
                aoSetting.getSalesUnitPriceDecimalPointNum(), StringUtil.defaultString(userForm.get("unit_price_fraction_div"), "0") ));
        BigDecimal subTotalPrice = new BigDecimal(AoUtil.convAoRoundingSalesPrice(retailPrice.toString()
                , String.valueOf(detail.get("order_quantity")), AoUtil.DispPattern.PATTERN_NO_COMMA,
                aoSetting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") ));

        return subTotalPrice;
    }

	@FormProperty
	public BigDecimal getOrderQuantity() {
        return orderQuantity;
    }

    public void setOrderQuantity(BigDecimal orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

	@FormProperty
    public BigDecimal getOrderCaseQuantity() {
        return orderCaseQuantity;
    }

    public void setOrderCaseQuantity(BigDecimal orderCaseQuantity) {
        this.orderCaseQuantity = orderCaseQuantity;
    }

    @FormProperty
    public BigDecimal getQuantityPerCase() {
        return quantityPerCase;
    }

    public void setQuantityPerCase(BigDecimal quantityPerCase) {
        this.quantityPerCase = quantityPerCase;
    }

    @FormProperty
    public Integer getCartId() {
		return cartId;
	}

	public void setCartId(Integer cartId) {
		this.cartId = cartId;
	}

	@FormProperty
	public String getItemCd() {
		return itemCd;
	}

	public void setItemCd(String itemCd) {
		this.itemCd = itemCd;
	}

	@FormProperty
	public BigDecimal getRetailPrice() {
		return retailPrice;
	}

	public void setRetailPrice(BigDecimal retailPrice) {
		this.retailPrice = retailPrice;
	}

	@FormProperty
	public BigDecimal getWholesalePrice() {
		return wholesalePrice;
	}

	public void setWholesalePrice(BigDecimal wholesalePrice) {
		this.wholesalePrice = wholesalePrice;
	}

	@FormProperty
	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	@FormProperty
	public String getItemImage1() {
		return itemImage1;
	}

	public void setItemImage1(String itemImage1) {
		this.itemImage1 = itemImage1;
	}

	@FormProperty
	public String getItemName1() {
		return itemName1;
	}

	public void setItemName1(String itemName1) {
		this.itemName1 = itemName1;
	}

	@FormProperty
	public String getItemName2() {
		return itemName2;
	}

	public void setItemName2(String itemName2) {
		this.itemName2 = itemName2;
	}

	@FormProperty
	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	@FormProperty
	public String getItemCategoryName1() {
		return itemCategoryName1;
	}

	public void setItemCategoryName1(String itemCategoryName1) {
		this.itemCategoryName1 = itemCategoryName1;
	}

	@FormProperty
	public String getItemCategoryName2() {
		return itemCategoryName2;
	}

	public void setItemCategoryName2(String itemCategoryName2) {
		this.itemCategoryName2 = itemCategoryName2;
	}

	@FormProperty
	public String getItemCategoryName3() {
		return itemCategoryName3;
	}

	public void setItemCategoryName3(String itemCategoryName3) {
		this.itemCategoryName3 = itemCategoryName3;
	}

	@FormProperty
	public String getItemCategoryName4() {
		return itemCategoryName4;
	}

	public void setItemCategoryName4(String itemCategoryName4) {
		this.itemCategoryName4 = itemCategoryName4;
	}

	@FormProperty
	public String getItemCategoryName5() {
		return itemCategoryName5;
	}

	public void setItemCategoryName5(String itemCategoryName5) {
		this.itemCategoryName5 = itemCategoryName5;
	}

	@FormProperty
	public String getItemCategoryName6() {
		return itemCategoryName6;
	}

	public void setItemCategoryName6(String itemCategoryName6) {
		this.itemCategoryName6 = itemCategoryName6;
	}

	@FormProperty
	public String getItemCategoryName7() {
		return itemCategoryName7;
	}

	public void setItemCategoryName7(String itemCategoryName7) {
		this.itemCategoryName7 = itemCategoryName7;
	}

	@FormProperty
	public String getItemCategoryName8() {
		return itemCategoryName8;
	}

	public void setItemCategoryName8(String itemCategoryName8) {
		this.itemCategoryName8 = itemCategoryName8;
	}

	@FormProperty
	public String getItemCategoryName9() {
		return itemCategoryName9;
	}

	public void setItemCategoryName9(String itemCategoryName9) {
		this.itemCategoryName9 = itemCategoryName9;
	}

	@FormProperty
	public String getItemCategoryName10() {
		return itemCategoryName10;
	}

	public void setItemCategoryName10(String itemCategoryName10) {
		this.itemCategoryName10 = itemCategoryName10;
	}

	@FormProperty
	public String getRemarks1() {
		return remarks1;
	}

	public void setRemarks1(String remarks1) {
		this.remarks1 = remarks1;
	}

	@FormProperty
	public String getRemarks2() {
		return remarks2;
	}

	public void setRemarks2(String remarks2) {
		this.remarks2 = remarks2;
	}

	@FormProperty
	public String getRemarks3() {
		return remarks3;
	}

	public void setRemarks3(String remarks3) {
		this.remarks3 = remarks3;
	}

	@FormProperty
	public String getRemarks4() {
		return remarks4;
	}

	public void setRemarks4(String remarks4) {
		this.remarks4 = remarks4;
	}

	@FormProperty
	public String getRemarks5() {
		return remarks5;
	}

	public void setRemarks5(String remarks5) {
		this.remarks5 = remarks5;
	}

	@FormProperty
	public String getRemarks6() {
		return remarks6;
	}

	public void setRemarks6(String remarks6) {
		this.remarks6 = remarks6;
	}

	@FormProperty
	public String getRemarks7() {
		return remarks7;
	}

	public void setRemarks7(String remarks7) {
		this.remarks7 = remarks7;
	}

	@FormProperty
	public String getRemarks8() {
		return remarks8;
	}

	public void setRemarks8(String remarks8) {
		this.remarks8 = remarks8;
	}

	@FormProperty
	public String getRemarks9() {
		return remarks9;
	}

	public void setRemarks9(String remarks9) {
		this.remarks9 = remarks9;
	}

	@FormProperty
	public String getRemarks10() {
		return remarks10;
	}

	public void setRemarks10(String remarks10) {
		this.remarks10 = remarks10;
	}

	@FormProperty
	public String getRemarks11() {
		return remarks11;
	}

	public void setRemarks11(String remarks11) {
		this.remarks11 = remarks11;
	}

	@FormProperty
	public String getUserItemCd() {
		return userItemCd;
	}

	public void setUserItemCd(String userItemCd) {
		this.userItemCd = userItemCd;
	}

	@FormProperty
	public String getUserItemName() {
		return userItemName;
	}

	public void setUserItemName(String userItemName) {
		this.userItemName = userItemName;
	}

	@FormProperty
	public String getUserItemName1() {
		return userItemName1;
	}

	public void setUserItemName1(String userItemName1) {
		this.userItemName1 = userItemName1;
	}

	@FormProperty
	public String getUserItemName2() {
		return userItemName2;
	}

	public void setUserItemName2(String userItemName2) {
		this.userItemName2 = userItemName2;
	}

	@FormProperty
	public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    @FormProperty
    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public Map<String, Object> toMap(AoSetting aoSetting, Map<String, Object> userForm) {
        Map<String, Object> cartMap = toMap();

        cartMap.put("order_quantity_format", getOrderQuantityFormat(aoSetting));
        cartMap.put("order_case_quantity_format", getOrderCaseQuantityFormat(aoSetting));
        cartMap.put("quantity_per_case_format", getQuantityPerCaseFormat(aoSetting));
        cartMap.put("retail_price_format", getRetailPriceFormat(aoSetting, userForm));
        cartMap.put("retail_sale_price_format", getRetailSalesPriceFormat(aoSetting, userForm));
        cartMap.put("whole_sale_price_format", getWholeSalePriceFormat(aoSetting, userForm));
        cartMap.put("sub_total_price_format", getSubTotalPriceFormat(aoSetting, userForm));

        return cartMap;
    }

    public static CartItem valueOf(Map<String, Object> map) {
		CartItem cart = new CartItem();

		if (map.get("cart_id") != null) {
		    cart.cartId = Integer.valueOf(String.valueOf(map.get("cart_id")));
		}
		cart.itemCd = StringUtil.defaultString(map.get("item_cd"), "");

		if (map.get("retail_price") != null) {
		    cart.retailPrice = StringUtil.toBigDecimal(String.valueOf(map.get("retail_price")), new BigDecimal(0.0));
		}
		if (map.get("wholesale_price") != null) {
		    cart.wholesalePrice = StringUtil.toBigDecimal(String.valueOf(map.get("wholesale_price")), new BigDecimal(0.0));
		}
		if (map.get("order_quantity") != null) {
		    cart.orderQuantity = StringUtil.toBigDecimal(String.valueOf(map.get("order_quantity")), new BigDecimal(0.0));
		}
		if (map.get("order_case_quantity") != null) {
		    cart.orderCaseQuantity = StringUtil.toBigDecimal(String.valueOf(map.get("order_case_quantity")), new BigDecimal(0.0));
		}
		if (map.get("quantity_per_case") != null) {
		    cart.quantityPerCase = StringUtil.toBigDecimal(String.valueOf(map.get("quantity_per_case")), new BigDecimal(0.0));
		}

		cart.unit = StringUtil.defaultString(map.get("unit"), "");
		cart.itemImage1 = StringUtil.defaultString(map.get("item_image1"), "");
		cart.itemImage2 = StringUtil.defaultString(map.get("item_image2"), "");
		cart.itemName1 = StringUtil.defaultString(map.get("item_name1"), "");
		cart.itemName2 = StringUtil.defaultString(map.get("item_name2"), "");
		cart.itemName = StringUtil.defaultString(map.get("item_name"), "");

		cart.userItemCd = StringUtil.defaultString(map.get("user_item_cd"), "");
		cart.userItemName = StringUtil.defaultString(map.get("user_item_name"), "");
		cart.userItemName1 = StringUtil.defaultString(map.get("user_item_name_1"), "");
		cart.userItemName2 = StringUtil.defaultString(map.get("user_item_name_2"), "");

		if (map.get("tax_price") != null) {
		    cart.taxPrice = StringUtil.toBigDecimal(String.valueOf(map.get("tax_price")), new BigDecimal(0.0));
		}
		if (map.get("tax_rate") != null) {
            cart.taxRate = StringUtil.toDouble(String.valueOf(map.get("tax_rate")), 0.0);
        }
		if (map.get("is_display") != null) {
		    cart.isDisplay = Boolean.valueOf(String.valueOf(map.get("is_display")));
		}

		if (map.get("order_no") != null) {
		    cart.orderNo = String.valueOf(map.get("order_no"));
		}

		if (map.get("record_no") != null) {
		    cart.recordNo = String.valueOf(map.get("record_no"));
		}

		if (map.get("stock_manage_div") != null) {
		    cart.stockManageDiv = String.valueOf(map.get("stock_manage_div"));
		}

		cart.userCd = StringUtil.defaultString(map.get("user_cd"), "");
		cart.userChargeId = StringUtil.defaultString(map.get("user_cd"), "");

		return cart;
	}

}
