package jp.ill.photon.model;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;

import jp.ill.photon.annotation.FormProperty;

public class Bill implements DomainObject {

    /** ファイル */
    File file;

    /** コンストラクタ */
    public Bill() {
    }

    /** コンストラクタ */
    public Bill(File file) {
        this.file = file;
    }

    /**
     * ファイルを取得.
     *
     * @return file
     */
    public File getFile() {
        return file;
    }

    /**
     * ファイルを設定.
     *
     * @param file
     */
    public void setFile(File file) {
        this.file = file;
    }

    /**
     * ファイルサイズを取得.
     *
     * @return ファイルサイズ
     */
    @FormProperty
    public BigDecimal getFileSize() {
        if (this.file == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal bdLength = new BigDecimal(this.file.length());
        return bdLength;
    }

    @FormProperty
    public String getFileName() {
        return file.getName();
    }

    @FormProperty
    public String getEncodedFileName() {
        try {
            // 半角スペース、IE、Chrome向け対応
            return URLEncoder.encode(file.getName(), "UTF-8").replace("+",
                    "%20");
        } catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static String getBillFilePath(String userCd, String fileName, String rootPath) {

		// 画像一覧取得
		Path root = Paths.get(rootPath);
		Path userRoot = root.resolve(userCd);
		Path target = userRoot.resolve(fileName);

		return target.toAbsolutePath().toString();
	}

}
