package jp.ill.photon.message;

import java.util.HashMap;
import java.util.Map;

public class ActionDtoMessage {

	/** メッセージが生成されたモジュールのreturn_prefix */
	private String returnPrefix;
	/** info_fieldまたはerror_fieldの場合、メッセージが対応するフォームフィールドコード。それ以外の場合はキー無し。 */
	private String formFieldCd;
	/** メッセージマスタのID */
	private String messageId;
	/** メッセージのフォーマット用パラメータ */
	private Map<String, Object> params;
	/** モジュールでは空で生成され、メッセージ変換処理を経由することでテキストメッセージが格納される。実際のメッセージはこの内容を表示する。 */
	private String message;

	/**
	 * returnPrefixを取得します。
	 * 
	 * @return returnPrefix
	 */
	public String getReturnPrefix() {
		return returnPrefix;
	}

	/**
	 * returnPrefixを設定します。
	 * 
	 * @param returnPrefix
	 */
	public void setReturnPrefix(String returnPrefix) {
		this.returnPrefix = returnPrefix;
	}

	/**
	 * formFieldCdを取得します。
	 * 
	 * @return formFieldCd
	 */
	public String getFormFieldCd() {
		return formFieldCd;
	}

	/**
	 * formFieldCdを設定します。
	 * 
	 * @param formFieldCd
	 */
	public void setFormFieldCd(String formFieldCd) {
		this.formFieldCd = formFieldCd;
	}

	/**
	 * messageIdを取得します。
	 * 
	 * @return messageId
	 */
	public String getMessageId() {
		return messageId;
	}

	/**
	 * messageIdを設定します。
	 * 
	 * @param messageId
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	/**
	 * paramsを取得します。
	 * 
	 * @return params
	 */
	public Map<String, Object> getParams() {
		if (params == null) {
			params = new HashMap<String, Object>();
		}
		return params;
	}

	/**
	 * paramsを設定します。
	 * 
	 * @param params
	 */
	public void setParams(Map<String, Object> params) {
		this.params = params;
	}

	/**
	 * messageを取得します。
	 * 
	 * @return message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * messageを設定します。
	 * 
	 * @param message
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<>();
		map.put("message", getMessage());
		map.put("message_id", getMessageId());
		map.put("form_field_cd", getFormFieldCd());
		map.put("return_prefix", getReturnPrefix());

		return map;
	}
}
