package jp.ill.photon.doma;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.SqlLogType;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;

/**
 * SQLとパラメータを元にPhotonSqlUpdateQueryを生成するファクトリクラス
 * 
 * @author h_tanaka
 *
 */
public class SqlUpdateQueryFactory extends AbstractSqlQueryFactory {

	public static SqlUpdateQueryFactory newInstance() {
		return new SqlUpdateQueryFactory();
	}

	/**
	 * SQLファイルとパラメータを元にPhotonSqlUpdateQueryを生成する
	 * 
	 * @param srcParams
	 * @param dto
	 * @param sqlFileDirPath
	 * @param sqlFilePath
	 * @return
	 * @throws PhotonModuleException
	 */
	public PhotonSqlUpdateQuery createUpdateQueryFromFile(	Map<String, Object> srcParams,
															ActionDto dto,
															String sqlFileDirPath,
															String sqlFilePath)
			throws PhotonModuleException {
		String sql = readSqlFile(sqlFileDirPath, sqlFilePath);
		return createUpdateQuery(srcParams, dto, sql);
	}

	/**
	 * SQLテキストとパラメータを元にPhotonSqlUpdateQueryを生成する
	 * 
	 * @param srcParams
	 * @param dto
	 * @param sql
	 * @return
	 * @throws PhotonModuleException
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public PhotonSqlUpdateQuery createUpdateQuery(	Map<String, Object> srcParams,
													ActionDto dto,
													String sql)
			throws PhotonModuleException {

		// パラメータデータを取得
		Map<String, Object> params = createSqlParams(srcParams, dto);
		Map<String, Object> paramTypes = createSqlParamTypes(srcParams);

		// SQLを解析
		SqlParser parser = createSqlParser(sql);

		// DomaのクエリオブジェクトにSQLをセットする
		PhotonSqlUpdateQuery updateQuery = new PhotonSqlUpdateQuery();
		updateQuery.setConfig(DomaConfig.singleton());
		updateQuery.setCallerClassName(getClass().getName());
		updateQuery.setCallerMethodName("execute");
		updateQuery.setSqlLogType(SqlLogType.FORMATTED);
		updateQuery.setSqlNode(parser.parse());

		// パラメータをクエリオブジェクトにセットする
		for (Map.Entry<String, Object> entry : params.entrySet()) {

			Map<String, String> typeDataTypeMap = (Map<String, String>) paramTypes
					.get(entry.getKey());
			String type = typeDataTypeMap.get("type");
			String dataType = typeDataTypeMap.get("data_type");

			Class clazz = null;
			Object defValue = null;
			Object setValue = null;
			if ("param_multi".equals(type)) {

				clazz = List.class;
				String[] strArr = (String[]) entry.getValue();

				if (DataTypes.NUMBER.equals(dataType)) {
					List<Integer> list = new ArrayList<Integer>();
					for (String item : strArr) {
						list.add(Integer.parseInt(item));
					}
					setValue = list;
				} else {
					List<String> list = new ArrayList<String>();
					for (String item : strArr) {
						list.add(item);
					}
					setValue = list;
				}

			} else {

				if (DataTypes.NUMBER.equals(dataType)) {
					clazz = Integer.class;
					setValue = (Integer) entry.getValue();
				} else {
					defValue = "";
					clazz = String.class;
					setValue = (String) entry.getValue();
				}

			}

			updateQuery.addParameter(entry.getKey(), clazz,
					(entry.getValue() == null ? defValue : setValue));

		}

		return updateQuery;
	}
}
