package jp.ill.photon.dao.builder;

import java.util.HashMap;
import java.util.Map;

public interface SimpleSQLBuilder {

	default String joinString(String... strings) {
		return String.join("", strings);
	}

	default String createJsonColName(String colName, Class type) {
		Map<Class, String> typeConvertMap = new HashMap<>();
		typeConvertMap.put(int.class, "int");

		String typeName = "text";
		if (type != null && typeConvertMap.containsKey(type)) {
			typeName = typeConvertMap.get(type);
			return joinString("(val->>'", colName, "')::", typeName);
		} else {
			return joinString("val->>'", colName, "'");
		}
	}

}
