package jp.ill.photon.dao.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;

import org.seasar.doma.jdbc.tx.TransactionManager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class SimpleJSONInsertSQLBuilder implements SimpleSQLBuilder {

	private JsonDataDao dao = null;

	/**
	 * Domaクエリビルダ用にSQLデータを生成する
	 *
	 * @param tenantId
	 * @param editTableCd
	 * @param where
	 * @param order
	 * @return
	 * @throws JsonProcessingException
	 */
	protected List<QueryPiece> build(	String tenantId,
										String editTableCd,
										String updateUserName,
										Map<String, Object> values)
			throws JsonProcessingException {
		if (editTableCd == null) {
			return new ArrayList<>();
		}

		ObjectMapper mapper = new ObjectMapper();
		String json = mapper.writeValueAsString(values);

		List<QueryPiece> query = new ArrayList<>();
		query.add(new SqlQueryPiece("insert into entity_data("));
		query.add(new SqlQueryPiece("tenant_id,"));
		query.add(new SqlQueryPiece("edit_table_cd,"));
		query.add(new SqlQueryPiece("insert_user_name,"));
		query.add(new SqlQueryPiece("insert_datetime,"));
		query.add(new SqlQueryPiece("update_user_name,"));
		query.add(new SqlQueryPiece("update_datetime,"));
		query.add(new SqlQueryPiece("val"));
		query.add(new SqlQueryPiece(")"));

		query.add(new SqlQueryPiece("values("));
		query.add(new ParamQueryPiece(String.class, tenantId));
		query.add(new SqlQueryPiece(","));
		query.add(new ParamQueryPiece(String.class, editTableCd));
		query.add(new SqlQueryPiece(","));
		query.add(new ParamQueryPiece(String.class, updateUserName));
		query.add(new SqlQueryPiece(","));
		query.add(new SqlQueryPiece("CURRENT_TIMESTAMP,"));
		query.add(new ParamQueryPiece(String.class, updateUserName));
		query.add(new SqlQueryPiece(","));
		query.add(new SqlQueryPiece("CURRENT_TIMESTAMP,"));

		query.add(new ParamQueryPiece(String.class, json));
		query.add(new SqlQueryPiece("::jsonb"));

		query.add(new SqlQueryPiece(")"));

		return query;
	}

	/**
	 * 指定条件でSQLを生成して結果をマップのリストで返す
	 *
	 * @param tenantId
	 * @param editTableCd
	 * @param where
	 * @param order
	 * @return
	 * @throws JsonProcessingException
	 */
	public int execute(	String tenantId,
						String editTableCd,
						String updateUserName,
						Map<String, Object> values)
			throws JsonProcessingException {
		List<QueryPiece> query = build(tenantId, editTableCd, updateUserName,
				values);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = getJsonDao();

		int result = tm.required(() -> {
			return dao.insert(query);
		});

		return result;
	}

	public int executeInTransation ( String tenantId,
            String editTableCd,
            String updateUserName,
            Map<String, Object> values)
        throws JsonProcessingException {
	    List<QueryPiece> query = build(tenantId, editTableCd, updateUserName,
                values);
	    int result = getJsonDao().insert(query);

	    return result;
	}

	protected JsonDataDao getJsonDao() {
		if (this.dao == null) {
			dao = new JsonDataDaoImpl();
		}
		return dao;
	}
}
