package jp.ill.photon.dao.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.postgresql.util.PGobject;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.util.JsonUtil;

public class JSONDomaSQLQueryBuilder extends AbstractDomaSQLQueryBuilder {

	private JsonDataDao dao = null;

	/**
	 * 指定条件でSQLを生成して結果をマップのリストで返す
	 * 
	 * @param tenantId
	 * @param query
	 * @return
	 */
	public List<Map<String, Object>> getListResult(	String query,
													Map<String, Object> params,
													ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = getJsonDao();

		List<Map<String, Object>> result = tm.required(() -> {
			return dao.selectList(domaQuery);
		});

		List<Map<String, Object>> resultList = new ArrayList<>();
		Map<String, Object> jsonValue = null;
		for (Map<String, Object> row : result) {
			jsonValue = JsonUtil
					.jsonToMap(((PGobject) row.get("val")).getValue());
			resultList.add(jsonValue);
		}

		return resultList;
	}

	/**
	 * 指定条件でSQLを生成して結果を単一マップで返す
	 * 
	 * @param tenantId
	 * @param query
	 * @return
	 */
	public Map<String, Object> getFirstResult(	String query,
												Map<String, Object> params,
												ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = getJsonDao();

		Map<String, Object> result = tm.required(() -> {
			return dao.selectOne(domaQuery);
		});

		Map<String, Object> jsonValue = null;
		if (result != null) {
			jsonValue = JsonUtil
					.jsonToMap(((PGobject) result.get("val")).getValue());
		}

		return jsonValue;
	}

	@Override
	public int insert(String query, Map<String, Object> params, ActionDto dto) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int update(String query, Map<String, Object> params, ActionDto dto) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int delete(String query, Map<String, Object> params, ActionDto dto) {
		// TODO Auto-generated method stub
		return 0;
	}

	protected JsonDataDao getJsonDao() {
		if (this.dao == null) {
			dao = new JsonDataDaoImpl();
		}
		return dao;
	}
}
