package jp.ill.photon.dao.builder;

import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.MetaObjectDao;
import jp.ill.photon.dao.MetaObjectDaoImpl;
import jp.ill.photon.dto.ActionDto;

public class DomaSQLQueryBuilder extends AbstractDomaSQLQueryBuilder {

	private MetaObjectDao dao = null;

	@Override
	public List<Map<String, Object>> getListResult(	String query,
													Map<String, Object> params,
													ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao dao = getMetaDao();

		List<Map<String, Object>> result = tm.required(() -> {
			return dao.selectList(domaQuery);
		});

		return result;
	}

	@Override
	public Map<String, Object> getFirstResult(	String query,
												Map<String, Object> params,
												ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao dao = getMetaDao();

		Map<String, Object> result = tm.required(() -> {
			return dao.selectOne(domaQuery);
		});

		return result;
	}

	@Override
	public int insert(String query, Map<String, Object> params, ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao dao = getMetaDao();

		int result = tm.required(() -> {
			return dao.insert(domaQuery);
		});

		return result;
	}

	@Override
	public int update(String query, Map<String, Object> params, ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao dao = getMetaDao();

		int result = tm.required(() -> {
			return dao.update(domaQuery);
		});

		return result;
	}

	@Override
	public int delete(String query, Map<String, Object> params, ActionDto dto) {
		List<QueryPiece> domaQuery = build(query, params, dto);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao dao = getMetaDao();

		int result = tm.required(() -> {
			return dao.delete(domaQuery);
		});

		return result;
	}

	protected MetaObjectDao getMetaDao() {
		if (this.dao == null) {
			dao = new MetaObjectDaoImpl();
		}
		return dao;
	}

}
