package jp.ill.photon.dao;

import java.util.List;
import java.util.Map;

import org.seasar.doma.BatchInsert;
import org.seasar.doma.Dao;
import org.seasar.doma.Select;

import jp.ill.photon.model.ErrorLog;

/**
 * AEC2.0のメタ定義テーブルのDaoクラス
 *
 * @author h_tanaka
 *
 */
@Dao(config = DomaConfig.class)
public interface MetaObjectDao extends BaseDao {

	/**
	 * URLに一致するパターンを持つアクション設定を取得する
	 *
	 * @param url
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectActionByURL(String url, boolean is_error);

	/**
	 * URLパターンに一致するパターンを持つアクション設定を取得する
	 *
	 * @param url
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectActionByUrlPattern(	String tenantId,
														String appId,
														String urlPattern);

	/**
	 * アクションIDに一致するアクション設定を取得する
	 * 
	 * @param tenantId
	 * @param appId
	 * @param actionID
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectActionByActionId(	String tenantId,
														String appId,
														String actionId);

	/**
	 * フックポイントで実行するフックアクション設定リストを取得する
	 *
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectFookActions(String tenantId, String appId);

	/**
	 * moduleIdListに含まれるmodule_idを持つモジュール設定を取得する
	 *
	 * @param moduleIdList
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectModuleByModuleIdList(List<String> moduleIdList);

	/**
	 * モジュール設定を取得する
	 *
	 * @param moduleId
	 * @return
	 */
	@Select
	Map<String, Object> getModule(String moduleId);

	/**
	 * テーブルのキー設定を取得する
	 *
	 * @param tables
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectTableKeyColumns(String tenantId,
													List<String> tables);

	/**
	 * validationSetIdListに含まれるvalidation_set_idを持つバリデーションセットを取得する
	 *
	 * @param tenantId
	 * @param validationSetIdList
	 * @return
	 */
	@Select
	List<Map<String, Object>> selectValidationSetByIdList(	String tenantId,
															List<String> validationSetIdList);

	/**
	 * エラーログを複数insertする
	 *
	 * @param tenantId
	 * @param errorTypeCd
	 * @param appId
	 * @param actionId
	 * @param scheduleId
	 * @param rowNo
	 * @param mesg
	 * @param jsonErrorInfo
	 * @return
	 */
	@BatchInsert(sqlFile = true)
	int[] insertErrorLogs(List<ErrorLog> logs);
}
