package jp.ill.photon.dao;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

import org.seasar.doma.Dao;
import org.seasar.doma.Delete;
import org.seasar.doma.Insert;
import org.seasar.doma.Select;
import org.seasar.doma.Update;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.model.CartItem;
import jp.ill.photon.model.Item;
import jp.ill.photon.model.ItemFile;
import jp.ill.photon.model.ItemStockThreshold;

/**
 * JSONデータテーブルのDAOクラス
 *
 * @author h_tanaka
 *
 */
@Dao(config = DomaConfig.class)
public interface JsonDataDao extends BaseDao {

	@Select
	List<Map<String, Object>> getDuplicatedList(String tenantId,
												String tableCd,
												String colCd,
												String paramValue,
												String exColCd,
												String exColValue);

	@Select
	List<Map<String, Object>> getExistingList(	String tenantId,
												String tableCd,
												String colCd,
												String paramValue);

	@Select
	List<Map<String, Object>> getWeekHolidayList(String tenantId);

	@Select
	List<Map<String, Object>> getHolidayList(String tenantId);

	@Select
	List<Map<String, Object>> getNewsFileData(String tenantId, String newsId);

	@Delete(sqlFile = true)
	int deleteDeliveryFeeCd(String tenantId, String deliveryFeeCd);

	@Delete(sqlFile = true)
	int deleteCalendarByYear(String tenantId, String year);

	@Select
	List<Map<String, Object>> getShoporder(String tenantId, String shopOrderNo);


	@Delete(sqlFile = true)
	int deleteOrderSpecialDetail(	String tenantId,
									String userCd,
									String orderNo,
									String chargeFeeItemCd,
									String deliveryFeeItemCd,
									String webOrderCampaignCd);

	@Update(sqlFile = true)
	int updateOrder(String tenantId,
					String userCd,
					String orderNo,
					String importPermitDiv,
					BigDecimal taxPrice,
					BigDecimal sumWholesalePrice,
					BigDecimal sumRetailPrice,
					BigDecimal totalOrderQuantity);

	@Update(sqlFile = true)
	int updateOrderDetail(	String tenantId,
							String userCd,
							String orderNo,
							int recordNo,
							String itemCd,
							BigDecimal orderQuantity,
							BigDecimal orderCaseQuantity,
							BigDecimal quantityPerCase,
							BigDecimal wholesalePrice,
							BigDecimal taxPrice,
							double taxRate,
							int taxCalcDiv,
							int taxFractionDigitDiv,
							int taxFractionDiv,
							int taxExemptDiv,
							int taxBracketCd);

	@Update(sqlFile = true)
	int updateCartItem(	String tenantId,
						String userCd,
						String userChargeId,
						CartItem cart);

	@Select
	List<Map<String, Object>> getSeqNextVal(String seqName);

	@Select
    List<Map<String, Object>> getSeqSfNextVal(String tenantId, String tableCd, String columnCd);

	@Select
	List<Map<String, Object>> getCartByItemCd(	String tenantId,
												String userCd,
												String userChargeId,
												String itemCd,
												boolean caseFlg);

	@Select
	List<Map<String, Object>> getCartByCartId(	String tenantId,
													String cartId,
													String userCd,
													String userChargeId);

	@Select
	List<Map<String, Object>> getCartQuantityCount(	String tenantId,
													String userCd,
													String userChargeId,
													String itemCd);

	@Select
	List<Map<String, Object>> getCartPriceList(	String tenantId,
												String userCd,
												String userChargeId,
												String priceCalcType,
												String condStrInTax,
												String condStrNoTax,
												String userPriceAdoptDiv,
												String uriageTankaSaiyoDiv,
												String deliveryCd);

	@Select
	List<Map<String, Object>> getItemUserPrice(	String tenantId,
												String itemCd,
												String userCd,
												String priceCalcType,
												String condStrInTax,
												String condStrNoTax,
												String userPriceAdoptDiv,
												String uriageTankaSaiyoDiv,
												String deliveryCd);

	@Select
	List<Map<String, Object>> getWebCampaignList(String tenantId);

	@Select
	List<Map<String, Object>> getWebCampaignListForOrderHisInfo(String tenantId,
																Timestamp orderDate);

	@Select
	List<Map<String, Object>> getChargeFeeSettingList(String tenantId);

	@Select
	List<Map<String, Object>> getLastSelectedDelivery(	String tenantId,
														String userCd,
														int userChargeId);

	@Select
	List<Map<String, Object>> getMatchingDeliveryFee(	String tenantId,
														String address);

	@Select
	List<Map<String, Object>> getTmpOrderDetail(String tenantId,
												String tmpOrderNo);

	@Select
	List<Map<String, Object>> getTmpOrder(String tenantId, String tmpOrderNo);

	@Select
	List<Map<String, Object>> getTmpOrderDetailExt(String tenantId,
												String tmpOrderNo);
	@Select
	List<Map<String, Object>> getTmpOrderExt(String tenantId, String tmpOrderNo);

	@Select
	List<Map<String, Object>> getPaymentWay(String tenantId,
											String paymentCd,
											String paymentMethodCd);

	@Select
	List<Map<String, Object>> getCreditNumberOfPayment(String tenantId);

	@Select
	List<Map<String, Object>> getCreditNumberOfPaymentMethod(String tenantId);

	@Select
	List<Map<String, Object>> getCreditPayment(String tenantId);

	@Select
	List<Map<String, Object>> getCreditPaymentMethod(String tenantId);

	@Select
	List<Map<String, Object>> getConveniencePayment(String tenantId);

	@Select
	List<Map<String, Object>> getSmbcPayment(String tenantId, String paymentCd);

	@Select
	List<Map<String, Object>> getUserPaymentSetting(String tenantId,
													String userCd);

	@Select
	List<Map<String, Object>> getPayment(String tenantId);

	@Select
	List<Map<String, Object>> getTaxSettingByTaxDivCd(	String tenantId,
														String taxDivCd,
														Timestamp date);

	@Select
	List<Map<String, Object>> getTaxRateByDate(String tenantId, Timestamp date);

	@Select
	List<Map<String, Object>> getTaxReducedRateByDate(	String tenantId,
														Timestamp date);

	@Select
	List<Map<String, Object>> getCartForOrder(	String tenantId,
												String cartId,
												String userCd,
												String userChargeId);

	@Select
	List<Map<String, Object>> getItemForOrder(	String tenantId,
												String itemCd,
												String userCd);

	@Delete(sqlFile = true)
	int deleteOrder(String tenantId, String orderNo);

	@Delete(sqlFile = true)
	int deleteOrderDetail(String tenantId, String orderNo);

	@Delete(sqlFile = true)
	int deleteOrderDetailByRecordNo(String tenantId,
									String orderNo,
									String recordNo);

	@Delete(sqlFile = true)
	int deleteCartItem(	String tenantId,
						String cartId,
						String userCd,
						String userChargeId);

	@Select
	List<Map<String, Object>> selectSettings(	String tenantId,
												List<String> targetTables);

	@Select
	List<Map<String, Object>> selectSortsByPageDiv(	String tenantId,
													String pageDiv);

	@Select
	List<Map<String, Object>> selectShohins(String tenantId,
											ActionDto dto,
											Map<String, String> params);

	@Select
	List<Map<String, Object>> selectShohinCategories(String tenantId, int no);

	@Select
	List<Map<String, Object>> selectSystemSettingValData(	String tenantId,
															String id);

	@Update(sqlFile = true)
	int updateFixedMessageData(String tenantId, String id, String note);

	@Update(sqlFile = true)
	int updateMailSettingData(	String tenantId,
								String mailId,
								String invalidFlg,
								String reMailName,
								String reMail,
								String ccMail,
								String bccMail,
								String mailTitle,
								String mailBody);

	@Select
	List<Map<String, Object>> selectTableData(	String tenantId,
												String tableCd,
												String columns,
												String searchConditions,
												String sortConditions,
												int offset,
												int limit);

	@Update(sqlFile = true)
	int updateShohinData(String tenantId, Item shohin);

	@Delete(sqlFile = true)
	int deleteShohinFiles(String tenantId, String itemCd);

	@Insert(sqlFile = true)
	int insertShohinFileData(String tenantId, ItemFile itemfile);

	@Select
	List<Map<String, Object>> selectShohinThresholdData(String tenantId,
														String itemCd);

	@Insert(sqlFile = true)
	int insertShohinThresholdData(	String tenantId,
									ItemStockThreshold itemStockThreshold);

	@Update(sqlFile = true)
	int updateShohinThresholdData(	String tenantId,
									ItemStockThreshold itemStockThreshold);

	@Insert(sqlFile = true)
	int insertShohinData(String tenantId, Item shohin);

	@Delete(sqlFile = true)
	int deleteShohinData(String tenantId, String itemCd);

	@Delete(sqlFile = true)
	int deleteShohinThresholdData(String tenantId, String itemCd);

	@Select
	List<Map<String, Object>> selectEditTableDataList(	String tenantId,
														String editTableCd,
														String columns,
														String where,
														String sort,
														String page,
														String limit);

	@Select
	List<Map<String, Object>> selectRowForDownload(	String tenantId,
													String editTableCd,
													String columns,
													String where);

	@Select
	Map<String, Object> insertEditTableData(String tenantId,
											String editTableCd,
											String userName,
											String data);

	@Select
	Map<String, Object> insertEditTableDataByGeneratedValue(String tenantId,
															String editTableCd,
															String userName,
															String data);
	@Select
	Map<String, Object> insertEditTableDataUsingScreenItemDefinitionFile(String tenantId,
															String editTableCd,
															String userName,
															String data,
															String screenItemDefinitionName,
															int defaultSize);

	@Select
	Map<String, Object> updateEditTableData(String tenantId,
											String editTableCd,
											String userName,
											String data);

	@Select
	Map<String, Object> deleteEditTableData(String tenantId,
											String editTableCd,
											String where);

	@Select
	Map<String, Object> deleteEditTableDataLogically(	String tenantId,
														String editTableCd,
														String userName,
														String where);

	@Select
	Map<String, Object> getEditTableRow(String tenantId,
										String editTableCd,
										String select,
										String where);

	@Select
	List<Map<String, Object>> getSelpopupColumns(	String tenantId,
													String editTableCd);

	@Delete(sqlFile = true)
	int deleteEditTableChildData(	String tenantId,
									String editTableCd,
									String where);

	@Update(sqlFile = true)
	int deleteEditTableChildDataLogically(	String tenantId,
											String editTableCd,
											String where,
											String userName);

	@Select
	Map<String, Object> getKeyColumns(String tenantId, String editTableCd);

	@Select
	List<Map<String, Object>> getLabelListShohinCategory(String tenantId);

	@Select
	List<Map<String, Object>> getFixedMessageListEditable(String tenantId);

	@Select
	List<Map<String, Object>> getMailPatternList(String tenantId);

	@Select
	Map<String, Object> insertEditTableDataByKeyColumns(String tenantId,
														String editTableCd,
														String userName,
														String data,
														String keyColumns);

	@Select
	Map<String, Object> updateEditTableDataByKeyColumns(String tenantId,
														String editTableCd,
														String userName,
														String data,
														String keyColumns);

	@Select
	List<Map<String, Object>> selectAdminUser(	String tenantId,
												String adminCd,
												String loginId,
												String mail);

	@Select
	List<Map<String, Object>> selectUserCharge(	String tenantId,
												String userChargeId,
												String loginId,
												String mail);

	@Select
	List<Map<String, Object>> selectUserChargeByUserChargeId(	String tenantId,
												String userChargeId);

	@Select
    List<Map<String, Object>> selectNewMemberApproval( String tenantId,
                                                String userChargeId,
                                                String loginId,
                                                String mail);

	@Select
	Map<String, Object> updateMergeEditTableData(	String tenantId,
													String editTableCd,
													String userName,
													String data,
													String keyColumns);

	@Select
	Map<String, Object> getUserByUserCdForUserSite(	String tenantId,
													String userCd,
													String deleteFlg);

	@Select
	Map<String, Object> getUserChargeInfoByUserCdUserChargeId(	String tenantId,
																String userCd,
																String userChargeId);

	@Select
	List<Map<String, Object>> getUserSystemAuthority(	String tenantId,
														String defValue,
														boolean adminDisp,
														String userChargeId);

	@Select
	List<Map<String, Object>> getListByUserChargeId(String tenantId,
													String userCd,
													String userChargeId);

	@Select
	Map<String, Object> getTableInfo(String tenantId,
									String editTableCd);

	@Select
	Map<String, Object> insertEditTableDataBySpecifiedFunction(String funcName,
																String tenantId,
																String editTableCd,
																String userName,
																String data);

	@Select
	Map<String, Object> updateEditTableDataBySpecifiedFunction(String funcName,
																String tenantId,
																String editTableCd,
																String userName,
																String data);

	@Select
	Map<String, Object> deleteEditTableDataBySpecifiedFunction(String funcName,
																String tenantId,
																String editTableCd,
																String where);

	@Select
	Map<String, Object> deleteEditTableDataLogicallyBySpecifiedFunction(String funcName,
																		String tenantId,
																		String editTableCd,
																		String userName,
																		String where);

	@Select
	Map<String, Object> selectEditTableDataFromJson(String tenantId, String editTableCd, String data);

	@Select
	Map<String, Object> selectEditTableDataFieldFromJson(String tenantId, String editTableCd, String data, String fieldColStr);

}
