package jp.ill.photon.dao;

import java.util.ResourceBundle;

import javax.sql.DataSource;

import org.seasar.doma.SingletonConfig;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.tx.LocalTransactionDataSource;
import org.seasar.doma.jdbc.tx.LocalTransactionManager;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.doma.CustomExpressions;
import jp.ill.photon.doma.Slf4jJdbcLogger;

@SingletonConfig
public class DomaConfig implements Config {

	private static final DomaConfig CONFIG = new DomaConfig();

	private Dialect dialect;
	private LocalTransactionDataSource tld;
	private TransactionManager tm;
	private JdbcLogger logger;

	private DomaConfig() {
		dialect = new PostgresDialect(new CustomExpressions());

		DataSource ds = null;
		// try {
		// Context ctx = new InitialContext();
		// ds = (DataSource) ctx.lookup("java:comp/env/jdbc/postgres");
		// tld = new LocalTransactionDataSource(ds);
		// } catch (NamingException e) {
		// e.printStackTrace();
		// }

		if (ds == null) {
			ResourceBundle bundle = ResourceBundle.getBundle("doma2");
			tld = new LocalTransactionDataSource(
					bundle.getString("doma2.ds.url"),
					bundle.getString("doma2.ds.user"),
					bundle.getString("doma2.ds.password"));
		}

		tm = new LocalTransactionManager(
				tld.getLocalTransaction(getJdbcLogger()));
		// tm = new LocalTransactionManager(
		// tld.getKeepAliveLocalTransaction(getJdbcLogger()));
	}

	@Override
	public JdbcLogger getJdbcLogger() {
		if (logger == null) {
			logger = new Slf4jJdbcLogger();
		}
		return logger;
	}

	@Override
	public DataSource getDataSource() {
		return tld;
	}

	@Override
	public Dialect getDialect() {
		return dialect;
	}

	@Override
	public TransactionManager getTransactionManager() {
		return tm;
	}

	public static DomaConfig singleton() {
		return CONFIG;
	}
}
