package jp.ill.photon.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonFrameworkException;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.exception.PhotonPageNotFoundException;
import jp.ill.photon.util.JsonUtil;

/**
 * コマンドラインやバッチプログラムからアクションを実行するためのメインクラス
 *
 * @author h_tanaka
 *
 */
public class PhotonMain {

	public static void main(String[] args) {
		Options options = new Options();
		options.addOption("u", "url", true, "action url");

		CommandLineParser parser = new DefaultParser();
		try {
			CommandLine cmd = parser.parse(options, args, true);
			List<String> restArguments = cmd.getArgList();
			Map<String, Object> parameters = new HashMap<>();
			String[] paramSet = null;
			String key = null;
			for (String arg : restArguments) {
				paramSet = arg.split("=");
				if (paramSet.length == 2) {
					key = paramSet[0].replace("--", "");
					parameters.put(key, new String[] { paramSet[1] });
				}
			}

			ActionDispatcher dispatcher = ActionDispatcher.getInstance();
			ActionDto dto = dispatcher.dispatch(cmd.getOptionValue("u"),
					parameters, null, "", null, null);

			System.out.println(JsonUtil.mapToJson(dto.getDataMap()));
		} catch (PhotonPageNotFoundException ex) {
			ex.printStackTrace();
		} catch (PhotonFrameworkException ex) {
			ex.printStackTrace();
		} catch (PhotonModuleException ex) {
			ex.printStackTrace();
		} catch (ParseException ex) {
			ex.printStackTrace();
		}
	}

}
