package jp.ill.photon.action;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonFrameworkException;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.exception.PhotonPageNotFoundException;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.StringUtil;

/**
 * すべてのリクエストを受け取るStrutsActionクラス
 *
 * @author h_tanaka
 *
 */
public class GeneralAction extends ActionSupport
		implements SessionAware, ServletRequestAware, ServletResponseAware {

	@Override
	public void setServletResponse(HttpServletResponse response) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setServletRequest(HttpServletRequest request) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setSession(Map<String, Object> session) {
		// TODO Auto-generated method stub

	}

	@Override
	public String execute() {

		HttpServletRequest request = ServletActionContext.getRequest();

		ActionDispatcher dispatcher = ActionDispatcher.getInstance();
		ActionContext context = ActionContext.getContext();
		ActionDto dto = null;

		try {
			dto = dispatcher.dispatch(request.getRequestURL().toString(),
					request, request.getSession(), null,
					context.getParameters(), null, null);
		} catch (PhotonPageNotFoundException ex) {
			dto = getActionErrorDto(request);
			dto.put("output.templatePath", "/share/content/404.html");
		} catch (PhotonModuleException | PhotonFrameworkException ex) {
			sendErrorMail(request, ex);
			dto = getActionErrorDto(request);
			dto.put("output.templatePath", "/share/content/500.html");
		} catch (Exception ex) {
			sendErrorMail(request, ex);
			dto = getActionErrorDto(request);
			dto.put("output.templatePath", "/share/content/500.html");
		}

		if (Arrays.asList(new String[] { "continue", "break" })
				.contains(dto.getResultType())) {
			setDto(dto);
			setParams(dto.getParams());

			if (dto.containsKey("output.input_stream")) {
				// TODO ootah: 判定方法は暫定
				inputStream = (InputStream) dto.get("output.input_stream");
				contentType = (String) dto.get("output.content_type");
				contentLength = StringUtil
						.defaultString(dto.get("output.content_length"), "0");
				contentDisposition = (String) dto
						.get("output.content_disposition");

				return "download";
			} else if (dto.containsKey("output.output_text")) {
				return "text";
			} else {
				StringBuffer path = new StringBuffer();
				if (dto.getAction() != null) {
					Path tenantDirPath = Paths.get(ServletActionContext
							.getServletContext().getRealPath("/"),
							dto.getTenantId());
					if (tenantDirPath.toFile().exists()) {
						path.append(dto.getTenantId());
						setTenantId(dto.getTenantId());
					} else {
						path.append("default");
						setTenantId("default");
					}
				} else {
					path.append("default");
					setTenantId("default");
				}
				path.append(dto.get("output.templatePath"));

				this.setTemplatePath(path.toString());

				return SUCCESS;
			}
		} else if (dto.getResultType().equals("redirect")) {
			String query = dto.getAfterParamQuery();
			if (query.length() > 0) {
				query = "?" + query;
			}
			this.setRedirectUrl(dto.getNextFullUrl() + query);
			return "redirect";
		}

		return ERROR;
	}

	/**
	 * システムエラーメールを送信
	 * 
	 * @param ex
	 */
	protected void sendErrorMail(HttpServletRequest request, Exception ex) {

		String requestURL = request.getRequestURL().toString();
		ActionFactory actInstance = ActionFactory.newInstance();
		Map<String, Object> actionSetting = actInstance
				.getActionSetting(requestURL, true);

		Map<String, Object> initParameters = new HashMap<>();
		initParameters.put("_init.remote_address", request.getRemoteAddr());
		initParameters.put("_init.remote_host", request.getRemoteHost());

		Map<String, Object> parameters = new HashMap<>();
		String[] param1 = { ex.getMessage() };
		String[] param2 = { requestURL };
		parameters.put("error_msg", param1);
		parameters.put("error_url", param2);
		ActionDispatcher dispatcher = ActionDispatcher.getInstance();
		try {
			dispatcher.dispatch(
					StringUtil.defaultString(
							actionSetting.getOrDefault("tenant_id", "1"), "1"),
					"batch", "/send_system_error_mail", initParameters,
					parameters, null, null);
		} catch (Exception e) {
			logger.error("システムエラーメール送信エラー", e);
		}
	}

	private ActionDto getActionErrorDto(HttpServletRequest request) {
		ActionDto dto = new ActionDto();
		ActionFactory actInstance = ActionFactory.newInstance();

		String requestURL = request.getRequestURL().toString();
		Map<String, Object> actionSetting = actInstance
				.getActionSetting(requestURL, true);
		Map<String, Object> initparams = actInstance.getInitParams(request,
				actionSetting);

		ActionParamMap aecParams = new ActionParamMap();
		for (Entry<String, Object> param : initparams.entrySet()) {
			aecParams.put(param.getKey(), (String) param.getValue());
		}
		dto.setAction(actionSetting);
		dto.setParams(aecParams);
		return dto;
	}

	private InputStream inputStream;
	private String contentType;
	private String contentLength;
	private String contentDisposition;

	private String redirectUrl;
	private String templatePath;
	private ActionDto dto;
	private ActionParamMap params;
	private String tenantId;

	public InputStream getInputStream() {
		return inputStream;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getContentLength() {
		if (contentLength == null || contentLength.length() == 0) {
			contentLength = "0";
		}
		return contentLength;
	}

	public void setContentLength(String contentLength) {
		this.contentLength = contentLength;
	}

	public String getContentDisposition() {
		return contentDisposition;
	}

	public void setContentDisposition(String contentDisposition) {
		this.contentDisposition = contentDisposition;
	}

	public String getRedirectUrl() {
		return redirectUrl;
	}

	public void setRedirectUrl(String redirectUrl) {
		this.redirectUrl = redirectUrl;
	}

	public String getTemplatePath() {
		return templatePath;
	}

	public void setTemplatePath(String templatePath) {
		this.templatePath = templatePath;
	}

	public ActionDto getDto() {
		return dto;
	}

	public void setDto(ActionDto dto) {
		this.dto = dto;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public ActionParamMap getParams() {
		return params;
	}

	public void setParams(ActionParamMap params) {
		this.params = params;
	}

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(GeneralAction.class);
}
