--- form
delete from form 
where tenant_id = '##tenant_id##'
and form_cd = '##code##'
;

insert into form(tenant_id, form_cd, name, remarks, sort_no, soft_const, disp_flg) 
values
(
    '##tenant_id##'
    , '##code##'
    , '##table_name##（外部連携：CSVインポート）'
    , 'CSVインポート時のフォーム定義です'
    , 999
    , '{}'::jsonb
    , 1
)
;

--- form_field
delete from form_field 
where tenant_id = '##tenant_id##'
and form_cd = '##code##'
;

insert into form_field(tenant_id, form_cd, form_field_cd, name, sort_no, remarks, validation_set_id, soft_const, disp_flg, edit_table_cd, col_cd) 
values
('##tenant_id##', '##code##', 'ex_renkei_upload_div', '削除マーク', 1, '（空:追加更新、1:削除）', 'ex_renkei_upload_div', '{}'::jsonb, 1, '', '')
##form_fields##
;

--- csv_io_setting
delete from csv_io_setting 
where tenant_id = '##tenant_id##'
and csv_io_cd = '##code##'
;

insert into csv_io_setting(tenant_id, csv_io_cd, form_cd, name, sort_no, remarks, disp_flg, encloser, encoding, delimiter, line_break) 
values
(
    '##tenant_id##'
    , '##code##'
    , '##code##'
    , '##table_name##（外部連携：CSVインポート）'
    , 999
    , 'CSVインポート時のフォーム定義です'
    , 1
    , '"'
    , 'UTF-8'
    , ','
    , 'CRLF'
)
;


--- csv_field
delete from csv_field 
where tenant_id = '##tenant_id##'
and csv_io_cd = '##code##'
;

insert into csv_field(tenant_id, csv_io_cd, csv_field_cd, sort_no, remarks, field_length) 
values
('##tenant_id##', '##code##', '削除マーク', 1, '（空:追加更新、1:削除）', '')
##csv_fields##
;

--- csv_convert_map
delete from csv_convert_map 
where tenant_id = '##tenant_id##'
and csv_io_cd = '##code##'
;

insert into csv_convert_map(tenant_id, csv_io_cd, form_fields, csv_fields, convert_settings, sort_no) 
values
('##tenant_id##', '##code##', '{"1": "ex_renkei_upload_div"}'::jsonb, '{"1": "削除マーク"}'::jsonb, '{}'::jsonb, 1)
##convert_maps##
;

--- job
delete from job 
where tenant_id = '##tenant_id##'
and job_id = '##code##'
;

insert into job(tenant_id, job_id, job_type, name, action_url, params, remarks, disp_flg, thread_id, app_id, url_pattern) 
values
(
    '##tenant_id##'
    , '##code##'
    , 'csv_import'
    , '##table_name##'
    , '/aec/batch/csv_import'
    , '{"csv_io_cd": "##code##", "sql_params": "", "sql_file_path": "aec20/##edit_table_cd##/importCsv.sql"}'::jsonb
    , ''
    , 1
    , 1
    , 'batch'
    , '/csv_import'
)
;

--- importsetting
delete from entity_data 
where tenant_id = '##tenant_id##'
and edit_table_cd = 'importsetting' 
and val->>'import_setting_cd' = '##code##'
;

SELECT
	SP_MERGE_ENTITY(
        '##tenant_id##'
        , 'importsetting'
        , 'ill'
        , jsonb_build_object(
            'import_setting_cd', '##code##',
            'name', '##table_name##',
            'dir_watch_setting_id', 'csv_import_dir',
            'job_id', '##code##',
            'file_name_pattern', upper('##edit_table_cd##'),
            'sort_no', '999',
            'disp_flg', '1'
        )
	)
;
