SELECT
    act.tenant_id,
    act.app_id,
    act.action_id,
    --act.action_def,
    act.name,
    act.remarks,
    act.format_version,
    ten.tenant_name,
    app.app_name,
    app.url_root,
    app.dburl,
    app.dbuser,
    app.dbpass,
	coalesce(sp_get_action_modules(act.tenant_id, act.app_id, act.action_id), '[]'::jsonb) as modules
FROM
    action act
    INNER JOIN tenant ten ON ten.tenant_id = act.tenant_id
    INNER JOIN app app ON ten.tenant_id = app.tenant_id and app.app_id = act.app_id
WHERE
    ten.disp_flg = '1'
AND
    act.disp_flg = 1
AND
    act.tenant_id = /* tenantId */'1'
AND
    act.app_id = /* appId */'ecuser'
AND
    act.action_id IN ('before_process_modules', 'after_process_modules')
ORDER BY
    act.action_id asc
