SELECT
	url.tenant_id,
	url.app_id,
	url.url_pattern,
	url.func_group_id,
	url.disp_flg,
	url.output_module_id,
	url.output_module_params,
	url.soft_const,
	url.url_save_flg,
	CAST( COALESCE(url.auth_level, 0) AS VARCHAR) AS auth_level,
	COALESCE(url.func_cd, '') AS func_cd,
	act.action_id,
	--act.action_def,
	act.name,
	act.remarks,
	act.format_version,
	ten.tenant_name,
	app.app_name,
	app.url_root,
	app.dburl,
	app.dbuser,
	app.dbpass,
	(app.url_root || url.url_pattern) as url_combined,
	case when url.output_module_id in ('ret_json', 'ret_xml') then
	   '1'
	else
	   '0'
	end as is_viewless_request,
	coalesce(sp_get_action_modules(act.tenant_id, act.app_id, act.action_id), '[]'::jsonb) as modules
FROM
	action act
	INNER JOIN action_url url ON url.tenant_id = act.tenant_id AND url.app_id = act.app_id AND url.action_id = act.action_id
	INNER JOIN tenant ten ON ten.tenant_id = url.tenant_id
	INNER JOIN app app ON ten.tenant_id = app.tenant_id AND app.app_id = url.app_id
WHERE
	ten.disp_flg = '1'
AND
	url.disp_flg = 1
AND
    act.disp_flg = 1
/*%if is_error */
AND
	/* url */'' ~ (app.url_root || url.url_pattern)
/*%else*/
AND
	/* url */'' = (app.url_root || url.url_pattern)
/*%end*/
ORDER BY
    url.priority desc,
   	length(url.url_pattern) desc,
	act.action_id asc
LIMIT 1
;
