SELECT
	count(*) OVER() as count,
	BI.VAL->>'item_id' ITEM_ID,
	BI.VAL->>'item_cd' ITEM_CD,
	BI.VAL->>'item_name1' ITEM_NAME1,
	BI.VAL->>'item_name2' ITEM_NAME2,
	COALESCE(BI.VAL->>'item_name1','') || COALESCE(BI.VAL->>'item_name2','') ITEM_NAME,
	BI.VAL->>'unit' UNIT,
	BI.VAL->>'sale_unit_price_no_tax' SALE_UNIT_PRICE_NO_TAX,
	BI.VAL->>'sale_unit_price_in_tax' SALE_UNIT_PRICE_IN_TAX,
	BI.VAL->>'retail_price' RETAIL_PRICE,
	BI.VAL->>'retail_price_tax_included' RETAIL_PRICE_TAX_INCLUDED,
	BI.VAL->>'item_category_cd_1' ITEM_CATEGORY_CD_1,
	BI.VAL->>'item_category_cd_2' ITEM_CATEGORY_CD_2,
	BI.VAL->>'item_category_cd_3' ITEM_CATEGORY_CD_3,
	BI.VAL->>'item_category_cd_4' ITEM_CATEGORY_CD_4,
	BI.VAL->>'item_category_cd_5' ITEM_CATEGORY_CD_5,
	BI.VAL->>'item_category_cd_6' ITEM_CATEGORY_CD_6,
	BI.VAL->>'item_category_cd_7' ITEM_CATEGORY_CD_7,
	BI.VAL->>'item_category_cd_8' ITEM_CATEGORY_CD_8,
	BI.VAL->>'item_category_cd_9' ITEM_CATEGORY_CD_9,
	BI.VAL->>'item_category_cd_10' ITEM_CATEGORY_CD_10,
	BIC1.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_1,
	BIC2.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_2,
	BIC3.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_3,
	BIC4.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_4,
	BIC5.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_5,
	BIC6.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_6,
	BIC7.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_7,
	BIC8.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_8,
	BIC9.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_9,
	BIC10.VAL->>'item_category_name' AS ITEM_CATEGORY_NAME_10,
	BI.VAL->>'item_image1' ITEM_IMAGE1,
	BI.VAL->>'item_image2' ITEM_IMAGE2,
	BI.VAL->>'item_image3' ITEM_IMAGE3,
	BI.VAL->>'item_image4' ITEM_IMAGE4,
	BI.VAL->>'item_image5' ITEM_IMAGE5,
	BI.VAL->>'remarks1' REMARKS1,
	BI.VAL->>'remarks2' REMARKS2,
	BI.VAL->>'remarks3' REMARKS3,
	BI.VAL->>'stock_div' STOCK_DIV,
	BI.VAL->>'jan_cd' JAN_CD,
	COALESCE((ST.VAL->>'web_stock_num')::numeric, 0.0) AS STOCK_NUM,
	BI.VAL->>'web_remarks1' WEB_REMARKS1,
	BI.VAL->>'web_remarks2' WEB_REMARKS2,
	BI.VAL->>'quantity_per_case' QUANTITY_PER_CASE

	/*%if params.get("withTanka") == "1" */
	,COALESCE(
		/*%if dto.getString("common.systemsetting.priceCalcType.note") == "1" */
			CASE
			WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'retail_price_tax_included'
				ELSE BI.VAL->>'retail_price'
			END
		/*%else*/
			CASE
   			/*%if params.get("userPriceAdoptDiv") == "2" */
				WHEN (/*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') AND TBL_CUP_DELI.VAL->'in_tax_campaign_unit_price' > 0)
					OR (/*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') AND TBL_CUP_DELI.VAL->'old_in_tax_campaign_unit_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') AND TBL_CUP_DELI.VAL->'out_tax_campaign_unit_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') AND TBL_CUP_DELI.VAL->'old_out_tax_campaign_unit_price' > 0) THEN
					CASE
						WHEN /*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') THEN TBL_CUP_DELI.VAL->'in_tax_campaign_unit_price'
						WHEN /*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') THEN TBL_CUP_DELI.VAL->'old_in_tax_campaign_unit_price'
						WHEN (/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') THEN TBL_CUP_DELI.VAL->'out_tax_campaign_unit_price'
						ELSE TBL_CUP_DELI.VAL->>'old_out_tax_campaign_unit_price'
					END
				/*%end*/
				WHEN (/*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') AND TBL_CUP.VAL->'in_tax_campaign_unit_price' > 0)
					OR (/*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') AND TBL_CUP.VAL->'old_in_tax_campaign_unit_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') AND TBL_CUP.VAL->'out_tax_campaign_unit_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') AND TBL_CUP.VAL->'old_out_tax_campaign_unit_price' > 0) THEN
					CASE
						WHEN /*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') THEN TBL_CUP.VAL->'in_tax_campaign_unit_price'
						WHEN /*# params.get("condStrInTax") */ AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') THEN TBL_CUP.VAL->'old_in_tax_campaign_unit_price'
						WHEN (/*# params.get("condStrNoTax") */) AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') THEN TBL_CUP.VAL->'out_tax_campaign_unit_price'
						ELSE TBL_CUP.VAL->>'old_out_tax_campaign_unit_price'
					END
				  /*%if params.get("userPriceAdoptDiv") == "2" */
				WHEN (/*# params.get("condStrInTax") */ AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'new_price_tax_included' > 0)
					OR ((/*# params.get("condStrInTax") */) AND TBL_UP_DELI.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_tax_included' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'new_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND TBL_UP_DELI.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price' > 0) THEN
					CASE
						WHEN /*# params.get("condStrInTax") */ AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'new_price_tax_included'
						WHEN /*# params.get("condStrInTax") */ AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'price_tax_included'
						WHEN (/*# params.get("condStrNoTax")*/) AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'new_price'
						ELSE TBL_UP_DELI.VAL->>'price'
					END
				/*%end*/
				WHEN (/*# params.get("condStrInTax") */ AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'new_price_tax_included' > 0)
					OR ((/*# params.get("condStrInTax") */) AND TBL_UP.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_tax_included' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'new_price' > 0)
					OR ((/*# params.get("condStrNoTax") */) AND TBL_UP.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'price' > 0) THEN
					CASE
						WHEN /*# params.get("condStrInTax") */ AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'new_price_tax_included'
						WHEN /*# params.get("condStrInTax") */ AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'price_tax_included'
						WHEN (/*# params.get("condStrNoTax") */) AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'new_price'
						ELSE TBL_UP.VAL->>'price'
					END
				ELSE
					CASE /*# dto.getString("common.aladdinsetting.売上単価採用区分.value") */
						WHEN '0' THEN
							CASE
								WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'sale_unit_price_in_tax'
								ELSE BI.VAL->>'sale_unit_price_no_tax'
							END
						WHEN '1' THEN
							CASE COALESCE(TBL_UPC.VAL->'price_rank', TBL_BU.VAL->>'price_rank')
								WHEN '1' THEN
									CASE
										WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'rank_price_6'
										ELSE BI.VAL->>'rank_price_1'
									END
								WHEN '2' THEN
									CASE
										WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'rank_price_7'
										ELSE BI.VAL->>'rank_price_2'
									END
								WHEN '3' THEN
									CASE
										WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'rank_price_8'
										ELSE BI.VAL->>'rank_price_3'
									END
								WHEN '4' THEN
									CASE
										WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'rank_price_9'
										ELSE BI.VAL->>'rank_price_4'
									END
								WHEN '5' THEN
									CASE
										WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'rank_price_10'
										ELSE BI.VAL->>'rank_price_5'
									END
								ELSE 0
							END
						WHEN '2' THEN
							(COALESCE(TBL_UPC.VAL->>'retail_price_rate', TBL_BU.VAL->>'retail_price_rate') / 100) * (CASE WHEN /*# params.get("condStrInTax") */ THEN BI.VAL->>'retail_price_tax_included' ELSE BI.VAL->>'retail_price' END)
						ELSE 0
					END
				END
			/*%end*/
			, 0) WHOLESALE_PRICE
	/*%else*/
	,0.0 WHOLESALE_PRICE
	/*%end*/

	--ログインユーザー用カラム
	/*%if params.getOrDefault("userCd", "") != "" */
	,CASE
		WHEN ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 1) OR
			 ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 2 AND (TBL_UAC.VAL->>'cart_disp_flg')::int = 1) THEN 1
		ELSE 0
	END AS CART_DISP_FLG
	,TBL_BU.VAL->>'user_cd'
	,TBL_FM.VAL->>'favorite_div'
	,TBL_FM.VAL->>'favorite_memo1'
	,TBL_FM.VAL->>'favorite_memo2'
	,TBL_FM.VAL->>'favorite_memo3'
	,TBL_FM.VAL->>'user_charge_id'
	,TBL_UC.VAL->>'user_charge_name'
	,TBL_BU.VAL->>'user_name1'
	,TBL_BU.VAL->>'user_name2'
	,COALESCE(TBL_BU.VAL->>'user_name1','') || COALESCE(TBL_BU.VAL->>'user_name2','') USER_NAME
	,TBL_UII.VAL->>'user_item_cd'
	,TBL_UII.VAL->>'user_item_name_1'
	,TBL_UII.VAL->>'user_item_name_2'
	,COALESCE(TBL_UII.VAL->>'user_item_name_1','') || COALESCE(TBL_UII.VAL->>'user_item_name_2','') USER_ITEM_NAME
	/*%end*/
FROM
  	entity_data BI
  	/*%if params.getOrDefault("userCd", "") != "" */
	-- 得意先商品情報マスタ
	LEFT JOIN entity_data TBL_UII ON TBL_UII.tenant_id = /* tenantId */'' AND  TBL_UII.edit_table_cd = 'useriteminfo' AND BI.VAL->'item_cd' = TBL_UII.VAL->'item_cd' AND TBL_UII.VAL->>'user_cd' = /* params.get("userCd") */''
	-- 得意先マスタ
	LEFT JOIN entity_data TBL_BU ON TBL_BU.tenant_id = /* tenantId */'' AND  TBL_BU.edit_table_cd = 'user' AND TBL_BU.VAL->'user_id' = TBL_UII.VAL->'user_cd'
	-- お気に入りメモテーブル
	LEFT JOIN entity_data TBL_FM ON TBL_FM.tenant_id = /* tenantId */'' AND  TBL_FM.edit_table_cd = 'favoritememo' AND BI.VAL->'item_cd' = TBL_FM.VAL->'item_cd' AND TBL_BU.VAL->'user_cd' = TBL_FM.VAL->'user_cd'
	-- 得意先別担当者マスタ
	LEFT JOIN entity_data TBL_UC ON TBL_UC.tenant_id = /* tenantId */'' AND  TBL_UC.edit_table_cd = 'usercharge' AND TBL_FM.VAL->'user_charge_id' = TBL_UC.VAL->'user_charge_id'
  	/*%end*/
  	LEFT JOIN entity_data ST ON ST.tenant_id = /* tenantId */'' AND  ST.edit_table_cd = 'webitemstock' AND ST.VAL->'item_cd' = BI.VAL->'item_cd'
  	LEFT JOIN entity_data BIC1 ON BIC1.tenant_id = /* tenantId */'' AND  BIC1.edit_table_cd = 'itemcategory1' AND BI.VAL->'item_category_cd_1' = BIC1.VAL->'item_category_cd'
  	LEFT JOIN entity_data BIC2 ON BIC2.tenant_id = /* tenantId */'' AND  BIC2.edit_table_cd = 'itemcategory2' AND BI.VAL->'item_category_cd_2' = BIC2.VAL->'item_category_cd'
  	LEFT JOIN entity_data BIC3 ON BIC3.tenant_id = /* tenantId */'' AND  BIC3.edit_table_cd = 'itemcategory3' AND BI.VAL->'item_category_cd_3' = BIC3.VAL->'item_category_cd'
  	LEFT JOIN entity_data BIC4 ON BIC4.tenant_id = /* tenantId */'' AND  BIC4.edit_table_cd = 'itemcategory4' AND BI.VAL->'item_category_cd_4' = BIC4.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC5 ON BIC5.tenant_id = /* tenantId */'' AND  BIC5.edit_table_cd = 'itemcategory5' AND BI.VAL->'item_category_cd_5' = BIC5.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC6 ON BIC6.tenant_id = /* tenantId */'' AND  BIC6.edit_table_cd = 'itemcategory6' AND BI.VAL->'item_category_cd_6' = BIC6.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC7 ON BIC7.tenant_id = /* tenantId */'' AND  BIC7.edit_table_cd = 'itemcategory7' AND BI.VAL->'item_category_cd_7' = BIC7.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC8 ON BIC8.tenant_id = /* tenantId */'' AND  BIC8.edit_table_cd = 'itemcategory8' AND BI.VAL->'item_category_cd_8' = BIC8.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC9 ON BIC9.tenant_id = /* tenantId */'' AND  BIC9.edit_table_cd = 'itemcategory9' AND BI.VAL->'item_category_cd_9' = BIC9.VAL->'item_category_cd'
	LEFT JOIN entity_data BIC10 ON BIC10.tenant_id = /* tenantId */'' AND  BIC10.edit_table_cd = 'itemcategory10' AND BI.VAL->'item_category_cd_10' = BIC10.VAL->'item_category_cd'
	/*%if params.getOrDefault("userCd", "") != "" */
	LEFT JOIN entity_data TBL_UAC ON TBL_UAC.tenant_id = /* tenantId */'' AND  TBL_UAC.edit_table_cd = 'useractivecartbtn' AND TBL_UAC.VAL->'user_cd' = TBL_BU.VAL->'user_cd' AND TBL_UAC.VAL->'item_cd' = BI.VAL->'item_cd'
	/*%end*/
	/*%if params.getOrDefault("search_form.catalogCd", "") != "" */
 	LEFT JOIN entity_data TBL_CI ON TBL_CI.tenant_id = /* tenantId */'' AND  TBL_CI.edit_table_cd = 'catalogitem' AND TBL_CI.VAL->'item_cd' = BI.VAL->'item_cd'
 	/*%end*/

    /*%if params.get("withTanka") == "1" */
    /*%if params.get("userPriceAdoptDiv") == "2" */
		LEFT JOIN entity_data TBL_CUP_DELI ON TBL_CUP_DELI.tenant_id = /* tenantId */'' AND  TBL_CUP_DELI.edit_table_cd = 'campaignunitprice' AND BI.VAL->'item_cd' = TBL_CUP_DELI.VAL->'item_cd' AND TBL_BU.VAL->'user_cd' = TBL_CUP_DELI.VAL->'user_cd' AND TBL_CUP_DELI.VAL->'user_delivery_cd' = /* params.get("deliveryCd") */''
		/*%end*/
		LEFT JOIN entity_data TBL_CUP ON TBL_CUP.tenant_id = /* tenantId */'' AND  TBL_CUP.edit_table_cd = 'campaignunitprice' AND BI.VAL->'item_cd' = TBL_CUP.VAL->'item_cd' AND TBL_BU.VAL->'user_cd' = TBL_CUP.VAL->'user_cd' AND TBL_CUP.VAL->'user_delivery_cd' = ''
		LEFT JOIN entity_data TBL_UP ON TBL_UP.tenant_id = /* tenantId */'' AND  TBL_UP.edit_table_cd = 'userprice' AND TBL_BU.VAL->'user_cd' = TBL_UP.VAL->'user_cd' AND BI.VAL->'item_cd' = TBL_UP.VAL->'item_cd' AND TBL_UP.VAL->'user_delivery_cd' = ''
    /*%if params.get("userPriceAdoptDiv") == "2" */
		LEFT JOIN entity_data TBL_UP_DELI ON TBL_UP_DELI.tenant_id = /* tenantId */'' AND  TBL_UP_DELI.edit_table_cd = 'userprice' AND TBL_BU.VAL->'user_cd' = TBL_UP_DELI.VAL->'user_cd' AND BI.VAL->'item_cd' = TBL_UP_DELI.VAL->'item_cd' AND TBL_UP_DELI.VAL->'user_delivery_cd' = /* params.get("deliveryCd") */''
		/*%end*/
		LEFT JOIN entity_data TBL_UPC ON TBL_UPC.tenant_id = /* tenantId */'' AND  TBL_UPC.tenant_id = /* tenantId */'' AND  TBL_UPC.edit_table_cd = 'userpricecalc' AND BI.VAL->'unit_price_category_cd' = TBL_UPC.VAL->'unit_price_category_cd' AND TBL_BU.VAL->'user_cd' = TBL_UPC.VAL->'user_cd'
    /*%end*/
WHERE
    1 = 1
AND
    BI.is_deleted = '0'
AND
    BI.tenant_id = /* tenantId */''
AND
    BI.edit_table_cd = 'item'
/*%if params.getOrDefault("search_form.item_cd", "") != "" */
AND
	BI.VAL->>'item_cd' = /* params.get("search_form.item_cd") */''
/*%end*/
AND
    (BI.VAL->>'disp_flg')::int = 1
AND /*%if params.get("userActiveItemFlg") == "0" */NOT/*%end*/ (
    ((BI.VAL->>'user_active_item_use_flg')::int = 1)
    OR (
       (BI.VAL->>'user_active_item_use_flg')::int = 2
       AND EXISTS(
           SELECT
              1
           FROM
              entity_data BUAI
           WHERE
              BUAI.tenant_id = /* tenantId */''
           AND
              BUAI.edit_table_cd = 'useractiveitem'
           AND
              BUAI.VAL->>'user_cd'  = '/*# params.getOrDefault("userCd", "") */'
	         AND
              BUAI.VAL->'item_cd' = BI.VAL->'item_cd'
	         AND
              (BUAI.VAL->>'active_div')::int = 1
	     )
   )
)
/*%if params.getOrDefault("userCd", "") != "" && params.getOrDefault("convMemo", "") != "" && params.get("isMemoVisible") == "1" */
AND ( FALSE
/*%if params.getOrDefault("isMemo1Visible", "") == "1" */
    OR TBL_FM.VAL->>'favorite_memo1_search' LIKE /* params.get("convMemo") */'%'
    /*%end*/
    /*%if params.getOrDefault("isMemo2Visible", "") == "1" */
    OR TBL_FM.VAL->>'favorite_memo2_search' LIKE /* params.get("convMemo") */'%'
    /*%end*/
    /*%if params.getOrDefault("isMemo3Visible", "") == "1" */
    OR TBL_FM.VAL->>'favorite_memo3_search' LIKE /* params.get("convMemo") */'%'
    /*%end*/
)
/*%end*/
/*%if (params.getOrDefault("search_form.memoFlg", "") != "" && params.getOrDefault("search_form.memoFlg", "") != "0") */
/*%if params.getOrDefault("isMemoVisible", "") == "1" */
/*%if params.getOrDefault("search_form.memoFlg", "") == "1" */
AND ( FALSE
/*%if params.getOrDefault("isMemo1Visible", "") == "1" */
    OR (TBL_FM.VAL->'favorite_memo1' IS NOT NULL AND TBL_FM.VAL->'favorite_memo1' <> '')
    /*%end*/
    /*%if params.get("isMemo2Visible") == "1" */
    OR (TBL_FM.VAL->'favorite_memo2' IS NOT NULL AND TBL_FM.VAL->'favorite_memo2' <> '')
    /*%end*/
    /*%if params.get("isMemo3Visible") == "1" */
    OR (TBL_FM.VAL->'favorite_memo3' IS NOT NULL AND TBL_FM.VAL->'favorite_memo3' <> '')
    /*%end*/
)
/*%end*/
/*%if params.getOrDefault("search_form.memoFlg", "") == "2" */
AND ( TRUE
/*%if params.getOrDefault("isMemo1Visible", "") == "1" */
    AND (TBL_FM.VAL->'favorite_memo1' IS NULL OR TBL_FM.VAL->'favorite_memo1' = '')
    /*%end*/
    /*%if params.get("isMemo2Visible") == "1" */
    AND (TBL_FM.VAL->'favorite_memo2' IS NULL OR TBL_FM.VAL->'favorite_memo2' = '')
    /*%end*/
    /*%if params.get("isMemo3Visible") == "1" */
    AND (TBL_FM.VAL->'favorite_memo3' IS NULL OR TBL_FM.VAL->'favorite_memo3' = '')
    /*%end*/
)
/*%end*/
/*%end*/
/*%end*/
/*%if params.getOrDefault("seach_form.favoriteFlg", "") == "1" */
AND
    TBL_FM.VAL->'favorite_div' IS NOT NULL
AND
    (TBL_FM.VAL->>'favorite_div')::int = 1
/*%end*/
/*%if params.getOrDefault("stockDiv", "") == "1" */
AND
    COALESCE((ST.VAL->>'web_stock_num')::numeric, 0) > 0
/*%end*/
/*%if params.getOrDefault("search_form.catalogCd", "") != "" */
AND
	TBL_CI.VAL->>'catalog_cd' = /* params.get("search_form.catalogCd") */''
/*%end*/

/*%if params.getOrDefault("search_form.key", "") != "" */
AND
  (
    BI.VAL->>'item_cd_search' LIKE /* @infix(@java.lang.String@valueOf(params.get("search_form.key"))) */''
    OR COALESCE(BI.VAL->>'item_name1_search','') || COALESCE(BI.VAL->>'item_name2_search','') LIKE /* @infix(@java.lang.String@valueOf(params.get("search_form.key"))) */''
    OR BI.VAL->>'remarks1_search' LIKE /* @infix(@java.lang.String@valueOf(params.get("search_form.key"))) */''
    OR BI.VAL->>'remarks2_search' LIKE /* @infix(@java.lang.String@valueOf(params.get("search_form.key"))) */''
    OR BI.VAL->>'remarks3_search' LIKE /* @infix(@java.lang.String@valueOf(params.get("search_form.key"))) */''
  )
/*%end*/

/*%if params.getOrDefault("withTanka", "") == "1" */
/*%if params.getOrDefault("search_form.pfr", "") != "" */
AND WHOLESALE_PRICE >= /* params.get("search_form.pfr") */0
/*%end*/
/*%if params.get("search_form.pto") != "" */
AND WHOLESALE_PRICE <= /* params.get("search_form.pto") */0
/*%end*/
/*%end*/

ORDER BY
      /*# params.getOrDefault("sortQuery", "BI.VAL->>$$item_cd$$ ASC") */
OFFSET /*# params.getOrDefault("search_form.offset", "0") */
LIMIT /*# params.getOrDefault("search_form.limit", "20") */
;
