WITH screenitemdef AS (
    SELECT
        COALESCE(
            (
                SELECT
                    SIDF.val->>'screen_item_definition_size' AS screen_item_definition_size
                FROM
                    entity_data AS SIDF
                WHERE
                    1 = 1
                AND
                    SIDF.tenant_id = /* tenantId */''
                AND
                    edit_table_cd = 'screenitemdefinitionfile'
                AND
                    SIDF.is_deleted = 0
                AND
                    SIDF.val->>'screen_item_definition_name' = /* screenItemDefinitionName */''
            ),
            CAST(/* defaultSize */10 AS TEXT)
        ) AS user_delivery_cd_size
),
user_delivery_cd_seq AS (
    SELECT nextval('t' || /* tenantId */'' || '__userdelivery__user_delivery_cd') as user_delivery_cd
),
generated_cd AS (
    SELECT
        ('{' ||
            '"user_delivery_cd" : "' || lpad(user_delivery_cd_seq.user_delivery_cd::text, screenitemdef.user_delivery_cd_size::Integer, '0'::text)
         || '"}')::jsonb AS generated_val
    FROM screenitemdef, user_delivery_cd_seq
)

SELECT
    SP_INSERT_ENTITY(
        /* tenantId */'',
        /* editTableCd */'',
        /* userName */'',
        ( /* data */'{}' )::jsonb || generated_cd.generated_val
    ) AS ret,
    generated_cd.generated_val AS generated_val
FROM generated_cd
;