SELECT
    CAM.VAL->>'campaign_cd' CAMPAIGN_CD,
    CAM.VAL->>'campaign_title' CAMPAIGN_TITLE,
    CAM.VAL->>'start_date' START_DATE,
    CAM.VAL->>'end_date' END_DATE,
    CAM.VAL->>'discount_div' DISCOUNT_DIV,
    CAM.VAL->>'discount_rate' DISCOUNT_RATE,
    CAM.VAL->>'fixed_discount_price' FIXED_DISCOUNT_PRICE,
    CAM.VAL->>'discount_amount_border' DISCOUNT_AMOUNT_BORDER,
    CAM.VAL->>'valid_flg' VALID_FLG
FROM
    entity_data CAM
WHERE
    CAM.is_deleted = '0'
    AND CAM.tenant_id = /* tenantId */''
    AND CAM.edit_table_cd = 'ordercampaign'
    AND (CAM.VAL->>'valid_flg')::int = 1
    AND sf_ifblank( CAM.VAL->>'start_date', null)::timestamp < CURRENT_TIMESTAMP
    AND sf_ifblank( CAM.VAL->>'end_date', null)::timestamp > CURRENT_TIMESTAMP
;