SELECT
	ORDERED_AUTH_DATA.user_charge_id,
	ORDERED_AUTH_DATA.user_function_cd,
	ORDERED_AUTH_DATA.user_function_name,
	ORDERED_AUTH_DATA.auth,
	( CASE WHEN ORDERED_AUTH_DATA.auth THEN '2' ELSE '0' END ) AS authority_div
FROM
	(
		SELECT
			( /* userChargeId */'' )::text AS user_charge_id,
			AUTH_DATA.user_function_cd AS user_function_cd,
			string_agg(AUTH_DATA.user_function_name, '') AS user_function_name,
			bool_and(AUTH_DATA.auth) AS auth,
			string_agg(AUTH_DATA.SORT_NO, '') AS sort_no
		FROM
			(
				SELECT
					TBL_UF.val->>'user_function_cd' user_function_cd,
					TBL_UF.val->>'user_function_name' user_function_name,
					(COALESCE(TBL_UA.AUTHORITY_DIV, /* defValue */'2' ) = '2') AS auth,
					TBL_UF.val->>'sort_no' AS sort_no
				FROM
					(
						SELECT
							*
						FROM
							entity_data UF
						WHERE
						    UF.is_deleted = '0'
							AND UF.tenant_id = /* tenantId */''
							AND UF.edit_table_cd = 'userfunction'
						/*%if adminDisp*/
							AND UF.val->>'screen_disp_flg' = 1
						/*%end*/
					) TBL_UF
					LEFT JOIN
					(
						SELECT
							UA.val->>'user_function_cd' user_function_cd,
							COALESCE(UA.val->>'authority_div', /* defValue */'2' ) authority_div
						FROM
							entity_data UA
						WHERE
						    UA.is_deleted = '0'
							AND UA.tenant_id = /* tenantId */''
							AND UA.edit_table_cd = 'userauthority'
							AND COALESCE(UA.val->>'user_charge_id', '') = ''
					) TBL_UA
					ON TBL_UF.val->>'user_function_cd' = TBL_UA.user_function_cd

				UNION ALL

				SELECT
					val->>'user_function_cd' AS user_function_cd,
					'' AS user_function_name,
					(val->>'authority_div' = '2') AS auth,
					'' AS sort_no
				FROM
					entity_data
				WHERE
					tenant_id = /* tenantId */'1'
					AND edit_table_cd = 'userauthority'
					AND val->>'user_charge_id' = /* userChargeId */''
			) AUTH_DATA
		GROUP BY
			AUTH_DATA.user_function_cd
	) ORDERED_AUTH_DATA
ORDER BY
	CAST( ( CASE WHEN ORDERED_AUTH_DATA.sort_no = '' THEN NULL ELSE ORDERED_AUTH_DATA.sort_no END ) AS INT ) ASC

