WITH
 setting_table_key AS (
	SELECT
		jsonb_object_agg(
			edit_table_cd, col_cd
		) AS val
	FROM
		entity_field
	WHERE
		tenant_id = /* tenantId */'1'
		AND edit_table_cd in ('systemsetting', 'aladdinsetting', 'label', 'mesg')
		AND key_no > 0
)
SELECT
	ef.tenant_id,
	ef.edit_table_cd,
	ef.col_cd,
	ef.col_cd AS key_cd,
	trim(to_char(ef.sort_no, '000')) as cond_no,
	ef.key_no,
	ef.name,
	ef.remarks,
	ef.sort_no,
	ef.version,
	ef.soft_const->>'disp_flg' AS disp_flg,
	ef.soft_const->>'unit_name' AS unit_name,
	ef.soft_const->>'valid_flg' AS valid_flg,
	ef.soft_const->>'unique_flg' AS unique_flg,
	ef.soft_const->>'choice_list' AS choice_list,
	ef.soft_const->>'list_sort_no' AS list_sort_no,
---	ef.soft_const->>'required_flg' AS required_flg,
	COALESCE((SELECT
			'1'::text
			FROM
			jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
			WHERE
			vm.module_id = 'validate_required'
			LIMIT 1
	), '0') AS required_flg,
	ef.soft_const->>'sel_popup_cd' AS sel_popup_cd,
	--- ef.soft_const->>'file_size_max' AS file_size_max,
	(
		SELECT
			CAST(COALESCE(sf_ifblank( params->'max_size'->>'val', NULL), '0') AS NUMERIC)
			*
			CASE
				WHEN params->'size_unit'->>'val' = 'MB' THEN 1024 * 1024
				WHEN params->'size_unit'->>'val' = 'KB' THEN 1024
				ELSE 1
			END
		FROM
		jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
		WHERE
		vm.module_id IN ('validate_file' ,'validate_max_file_size')
		LIMIT 1
	)::TEXT AS file_size_max,
	ef.soft_const->>'null_blank_flg' AS null_blank_flg,
	ef.soft_const->>'data_input_type' AS data_input_type,
	ef.soft_const->>'text_input_size' AS text_input_size,
	ef.soft_const->>'text_length_max' AS text_length_max,
	--- ef.soft_const->>'text_length_min' AS text_length_min,
	(
		SELECT
			CASE
				WHEN jsonb_typeof(params->'min_length') = 'object' THEN
					CASE
						WHEN params->'min_length'->>'type' = 'dto' THEN
							(
								SELECT val->>( split_part(params->'min_length'->>'val', '.', 4) )
								FROM
									entity_data d
								WHERE
									d.tenant_id = /* tenantId */'1'
									AND d.edit_table_cd = split_part(params->'min_length'->>'val', '.', 2)
									AND d.is_deleted = 0
									AND d.val->>( SELECT stk.val->>( split_part(params->'min_length'->>'val', '.', 2) ) FROM setting_table_key stk LIMIT 1 ) = split_part(params->'min_length'->>'val', '.', 3)
							)
						ELSE
							params->'min_length'->>'val'
					END
				ELSE params->>'min_length'
			END
		FROM
		jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
		WHERE
		vm.module_id = 'validate_min_byte_length'
		LIMIT 1
	) AS text_length_min,
	ef.soft_const->>'text_number_max' AS text_number_max,
	ef.soft_const->>'text_number_min' AS text_number_min,
	ef.soft_const->>'text_data_format' AS text_data_format,
	ef.soft_const->>'etcol_autonum_div' AS etcol_autonum_div,
	ef.soft_const->>'file_image_use_flg' AS file_image_use_flg,
	--- ef.soft_const->>'file_extension_list' AS file_extension_list,
	COALESCE((SELECT
		--params->'list'->'val'
		string_agg( d.value, ',')
		FROM
		jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text),
		jsonb_array_elements_text(params->'list'->'val') AS d
		WHERE
		vm.module_id IN ( 'validate_file' ,'validate_extension' )
		LIMIT 1
	), '') AS file_extension_list,
	ef.soft_const->>'input_help_disp_flg' AS input_help_disp_flg,
	ef.soft_const->>'etcol_autonum_length' AS etcol_autonum_length,
	ef.soft_const->>'choice_list_separator' AS choice_list_separator,
	ef.soft_const->>'file_image_disp_width' AS file_image_disp_width,
	ef.soft_const->>'text_number_digit_div' AS text_number_digit_div,
	ef.soft_const->>'file_name_select_query' AS file_name_select_query,
	ef.soft_const->>'text_length_count_type' AS text_length_count_type,
	--- ef.soft_const->>'text_length_limit_type' AS text_length_limit_type,
	(
		SELECT
			CASE
				WHEN ( array_agg(module_id) @> ARRAY['validate_min_byte_length'] ) AND ( array_agg(module_id) @> ARRAY['validate_max_byte_length'] ) THEN

					CASE
						WHEN
								(
									SELECT
										CASE
											WHEN jsonb_typeof(params->'min_length') = 'object' THEN
												CASE
													WHEN params->'min_length'->>'type' = 'dto' THEN
														(
															SELECT val->>( split_part(params->'min_length'->>'val', '.', 4) )
															FROM
																entity_data d
															WHERE
																d.tenant_id = /* tenantId */'1'
																AND d.edit_table_cd = split_part(params->'min_length'->>'val', '.', 2)
																AND d.is_deleted = 0
																AND d.val->>( SELECT stk.val->>( split_part(params->'min_length'->>'val', '.', 2) ) FROM setting_table_key stk LIMIT 1 ) = split_part(params->'min_length'->>'val', '.', 3)
														)
													ELSE
														params->'min_length'->>'val'
												END
											ELSE params->>'min_length'
										END
									FROM
									jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
									WHERE
									vm.module_id = 'validate_min_byte_length'
									LIMIT 1
								)
								=
								(
									SELECT
										CASE
											WHEN jsonb_typeof(params->'max_length') = 'object' THEN
												CASE
													WHEN params->'max_length'->>'type' = 'dto' THEN
														(
															SELECT val->>( split_part(params->'max_length'->>'val', '.', 4) )
															FROM
																entity_data d
															WHERE
																d.tenant_id = /* tenantId */'1'
																AND d.edit_table_cd = split_part(params->'max_length'->>'val', '.', 2)
																AND d.is_deleted = 0
																AND d.val->>( SELECT stk.val->>( split_part(params->'max_length'->>'val', '.', 2) ) FROM setting_table_key stk LIMIT 1 ) = split_part(params->'max_length'->>'val', '.', 3)
														)
													ELSE
														params->'max_length'->>'val'
												END
											ELSE params->>'max_length'
										END
									FROM
									jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
									WHERE
									vm.module_id = 'validate_max_byte_length'
									LIMIT 1
								) THEN '4'

						ELSE '3'
					END
				ELSE
					CASE
						WHEN array_agg(module_id) @> ARRAY['validate_min_byte_length'] THEN '2'
						WHEN array_agg(module_id) @> ARRAY['validate_max_byte_length'] THEN '1'
						ELSE '0'
					END
			END AS val
		FROM
		jsonb_to_recordset(v.validations->'list') AS vm(params jsonb, is_last boolean, type text, module_id text)
		WHERE
		vm.module_id IN ('validate_min_byte_length', 'validate_max_byte_length')
	) AS text_length_limit_type,
	ef.soft_const->>'text_number_limit_type' AS text_number_limit_type,
	ef.soft_const->>'etcol_autonum_table_name' AS etcol_autonum_table_name,
	ef.soft_const->>'reversal_check_column_no' AS reversal_check_column_no,
	ef.soft_const->>'ao_set_name_digit_decimal' AS ao_set_name_digit_decimal,
	ef.soft_const->>'etcol_autonum_column_name' AS etcol_autonum_column_name,
	ef.soft_const->>'sub_dir_name_select_query' AS sub_dir_name_select_query,
	ef.soft_const->>'text_number_digit_decimal' AS text_number_digit_decimal,
	ef.soft_const->>'ao_set_name_digit_integral' AS ao_set_name_digit_integral,
	ef.soft_const->>'text_number_digit_integral' AS text_number_digit_integral,
	ef.soft_const->>'text_half_num_zero_fill_flg' AS text_half_num_zero_fill_flg,
	ef.soft_const->>'text_illegal_char_check_div' AS text_illegal_char_check_div,
	ef.soft_const->>'file_store_path_system_setting_id' AS file_store_path_system_setting_id,
	ef.soft_const->>'file_context_path_system_setting_id' AS file_context_path_system_setting_id,
	ef.soft_const->>'validation_set' AS validation_set
FROM
	entity_field ef
	LEFT OUTER JOIN
	validation_set v
	ON v.tenant_id = /* tenantId */''
	AND ef.soft_const->>'validation_set' = v.validation_set_id

WHERE
	ef.tenant_id = /* tenantId */''
	AND ef.edit_table_cd = /* editTableCd */''
	AND ef.soft_const->>'valid_flg' = '1'
	AND ef.soft_const->>'disp_flg' = '1'
ORDER BY
	ef.sort_no ASC

