SELECT  *
FROM (
    SELECT  FEE1.VAL->>'delivery_fee_cd' DELIVERY_FEE_CD,
            FEE1.VAL->>'record_no' RECORD_NO,
            FEE1.VAL->>'area_name' AREA_NAME,
            FEE1.VAL->>'delivery_charge' DELIVERY_CHARGE,
            FEE1.VAL->>'address' ADDRESS,
            FEE1.VAL->>'priory_no' PRIORY_NO
        ,   0 AS UNION_DIV
    FROM    entity_data FEE1
    WHERE FEE1.is_deleted = '0'
    AND FEE1.tenant_id = /* tenantId */''
    AND FEE1.edit_table_cd = 'deliveryfee'
    AND /*address*/'' LIKE CONCAT(CONCAT('%', FEE1.VAL->>'address'), '%')

    UNION ALL
    SELECT  *
    FROM (
    SELECT  FEE2.VAL->>'delivery_fee_cd' DELIVERY_FEE_CD,
            FEE2.VAL->>'record_no' RECORD_NO,
            FEE2.VAL->>'area_name' AREA_NAME,
            FEE2.VAL->>'delivery_charge' DELIVERY_CHARGE,
            FEE2.VAL->>'address' ADDRESS,
            FEE2.VAL->>'priory_no' PRIORY_NO
        ,   1 AS UNION_DIV
    FROM    entity_data FEE2
    WHERE FEE2.is_deleted = '0'
    AND FEE2.tenant_id = /* tenantId */''
    AND FEE2.edit_table_cd = 'deliveryfee'
    AND '*' = FEE2.VAL->>'address'
    ORDER BY (FEE2.VAL->>'priory_no')::int ASC, (FEE2.VAL->>'delivery_fee_cd')::int ASC
    LIMIT 1
    ) TMP

    UNION ALL
    SELECT  *
    FROM (
    SELECT  FEE3.VAL->>'delivery_fee_cd' DELIVERY_FEE_CD,
            FEE3.VAL->>'record_no' RECORD_NO,
            FEE3.VAL->>'area_name' AREA_NAME,
            FEE3.VAL->>'delivery_charge' DELIVERY_CHARGE,
            FEE3.VAL->>'address' ADDRESS,
            FEE3.VAL->>'priory_no' PRIORY_NO
        ,   2 AS UNION_DIV
    FROM    entity_data FEE3
    WHERE FEE3.is_deleted = '0'
    AND FEE3.tenant_id = /* tenantId */''
    AND FEE3.edit_table_cd = 'deliveryfee'
    ORDER BY (FEE3.VAL->>'priory_no')::int ASC, (FEE3.VAL->>'delivery_fee_cd')::int ASC
    LIMIT 1
    ) TMP

) TMP
ORDER BY UNION_DIV ASC, PRIORY_NO ASC, DELIVERY_FEE_CD ASC
LIMIT 1