SELECT
    -- お届け先コードが設定されていない場合は自社(得意先)の情報を返します
    OLD.USER_DELIVERY_CD,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'user_name1' ELSE TBUD.VAL->>'user_delivery_name1' END AS USER_DELIVERY_NAME1,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'user_name2' ELSE TBUD.VAL->>'user_delivery_name2' END AS USER_DELIVERY_NAME2,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'zip' ELSE TBUD.VAL->>'zip' END AS ZIP,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'city_name1' ELSE TBUD.VAL->>'city_name1' END AS CITY_NAME_1,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'city_name2' ELSE TBUD.VAL->>'city_name2' END AS CITY_NAME_2,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'city_name3' ELSE TBUD.VAL->>'city_name3' END AS CITY_NAME_3,
	CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN coalesce(TBU.VAL->>'city_name1', '') || coalesce(TBU.VAL->>'city_name2', '') || coalesce(TBU.VAL->>'city_name3', '') ELSE coalesce(TBUD.VAL->>'city_name1', '') || coalesce(TBUD.VAL->>'city_name2', '') || coalesce(TBUD.VAL->>'city_name3', '') END AS CITY_NAME,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'tel' ELSE TBUD.VAL->>'tel' END AS TEL,
    CASE WHEN OLD.USER_DELIVERY_CD IS NULL THEN TBU.VAL->>'fax' ELSE TBUD.VAL->>'fax' END AS FAX,
    OLD.INSERT_DATETIME
FROM (
    SELECT
        *
    FROM
        (
        SELECT
            ORD.VAL->>'user_cd' USER_CD,
            ORD.VAL->>'user_delivery_cd' USER_DELIVERY_CD,
            ORD.VAL->>'insert_datetime' INSERT_DATETIME,
            ORD.VAL->>'order_make_user_charge_id' USER_CHARGE_ID
        FROM
            entity_data ORD
        WHERE
            ORD.is_deleted = '0'
            AND ORD.tenant_id= /* tenantId */''
            AND ORD.edit_table_cd = 'order'
            AND (ORD.VAL->>'order_make_user_charge_id')::int = /*userChargeId*/1
            AND ORD.VAL->>'user_cd' = /*userCd*/''
        UNION ALL
        SELECT
            EST.VAL->>'user_cd' USER_CD,
            EST.VAL->>'user_delivery_cd' USER_DELIVERY_CD,
            EST.VAL->>'insert_datetime' INSERT_DATETIME,
            EST.VAL->>'estimate_make_user_charge_id' USER_CHARGE_ID
        FROM
            entity_data EST
        WHERE
            EST.is_deleted = '0'
            AND EST.tenant_id= /* tenantId */''
            AND EST.edit_table_cd = 'estimate'
            AND (EST.VAL->>'estimate_make_user_charge_id')::int = /*userChargeId*/1
            AND EST.VAL->>'user_cd' = /*userCd*/''
        ) TMP
    ORDER BY
        INSERT_DATETIME DESC
    OFFSET 0 LIMIT 1
    ) OLD
    LEFT JOIN entity_data TBUD
    ON TBUD.tenant_id = /* tenantId */'' AND TBUD.edit_table_cd = 'userdelivery'
    AND OLD.USER_DELIVERY_CD = TBUD.VAL->>'user_delivery_cd'
    LEFT JOIN entity_data TBUC
    ON TBUD.tenant_id = /* tenantId */'' AND TBUD.edit_table_cd = 'usercharge'
    AND OLD.USER_CHARGE_ID = TBUC.VAL->>'user_charge_id'
    LEFT JOIN entity_data TBU
    ON TBUD.tenant_id = /* tenantId */'' AND TBUD.edit_table_cd = 'user'
    AND OLD.USER_CD = TBU.VAL->>'user_cd'
WHERE (TBUD.VAL->>'delete_flg' IS NULL OR TBUD.VAL->>'delete_flg' != '1')
;
