WITH labels AS (
	SELECT
		BIC.val->>'id' AS id,
		BIC.val->>'name' AS name,
		BIC.val->>'note' AS note
	FROM
		entity_data BIC
	WHERE
		1 = 1
	AND
	    BIC.is_deleted = '0'
	AND
		BIC.tenant_id = /* tenantId */'1'
	AND
		BIC.edit_table_cd = 'label'
	ORDER BY
		BIC.val->>'id' ASC
)
SELECT * FROM labels WHERE 1 = 1 AND id LIKE 'item_category__label'
UNION ALL
SELECT * FROM labels WHERE 1 = 1 AND id LIKE 'item_category___label'
;
