SELECT
    count(*) OVER() as count,
    BI.VAL->>'item_id' ITEM_ID,
    BI.VAL->>'item_cd' ITEM_CD,
    BI.VAL->>'item_name1' ITEM_NAME1,
    BI.VAL->>'item_name2' ITEM_NAME2,
    COALESCE(BI.VAL->>'item_name1','') || COALESCE(BI.VAL->>'item_name2','') ITEM_NAME,
    BI.VAL->>'unit' UNIT,
    BI.VAL->>'sale_unit_price_no_tax' SALE_UNIT_PRICE_NO_TAX,
    BI.VAL->>'sale_unit_price_in_tax' SALE_UNIT_PRICE_IN_TAX,
    BI.VAL->>'retail_price' RETAIL_PRICE,
    BI.VAL->>'retail_price_tax_included' RETAIL_PRICE_TAX_INCLUDED,
    BI.VAL->>'item_category_cd_1' ITEM_CATEGORY_CD_1,
    BI.VAL->>'item_category_cd_2' ITEM_CATEGORY_CD_2,
    BI.VAL->>'item_category_cd_3' ITEM_CATEGORY_CD_3,
    BI.VAL->>'item_category_cd_4' ITEM_CATEGORY_CD_4,
    BI.VAL->>'item_category_cd_5' ITEM_CATEGORY_CD_5,
    BI.VAL->>'item_category_cd_6' ITEM_CATEGORY_CD_6,
    BI.VAL->>'item_category_cd_7' ITEM_CATEGORY_CD_7,
    BI.VAL->>'item_category_cd_8' ITEM_CATEGORY_CD_8,
    BI.VAL->>'item_category_cd_9' ITEM_CATEGORY_CD_9,
    BI.VAL->>'item_category_cd_10' ITEM_CATEGORY_CD_10,
    BI.VAL->>'item_image1' ITEM_IMAGE1,
    BI.VAL->>'item_image2' ITEM_IMAGE2,
    BI.VAL->>'item_image3' ITEM_IMAGE3,
    BI.VAL->>'item_image4' ITEM_IMAGE4,
    BI.VAL->>'item_image5' ITEM_IMAGE5,
    BI.VAL->>'remarks1' REMARKS1,
    BI.VAL->>'remarks2' REMARKS2,
    BI.VAL->>'remarks3' REMARKS3,
    BI.VAL->>'stock_div' STOCK_DIV,
    BI.VAL->>'jan_cd' JAN_CD,
    BI.VAL->>'web_remarks1' WEB_REMARKS1,
    BI.VAL->>'web_remarks2' WEB_REMARKS2,
    BI.VAL->>'quantity_per_case' QUANTITY_PER_CASE
    ,COALESCE(
        /*%if priceCalcType == "1" */
            CASE
            WHEN /*# condStrInTax */ THEN BI.VAL->>'retail_price_tax_included'
                ELSE BI.VAL->>'retail_price'
            END
        /*%else*/
            CASE
            /*%if userPriceAdoptDiv == "2" */
                WHEN (/*# condStrInTax */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') AND TBL_CUP_DELI.VAL->'in_tax_campaign_unit_price' > 0)
                    OR (/*# condStrInTax */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') AND TBL_CUP_DELI.VAL->'old_in_tax_campaign_unit_price' > 0)
                    OR ((/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') AND TBL_CUP_DELI.VAL->'out_tax_campaign_unit_price' > 0)
                    OR ((/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') AND TBL_CUP_DELI.VAL->'old_out_tax_campaign_unit_price' > 0) THEN
                    CASE
                        WHEN /*# condStrInTax */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') THEN TBL_CUP_DELI.VAL->'in_tax_campaign_unit_price'
                        WHEN /*# condStrInTax */ AND IS_IN_TERM(TBL_CUP_DELI.VAL->'old_start_setting_date', TBL_CUP_DELI.VAL->'old_end_setting_date') THEN TBL_CUP_DELI.VAL->'old_in_tax_campaign_unit_price'
                        WHEN (/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP_DELI.VAL->'start_setting_date', TBL_CUP_DELI.VAL->'end_setting_date') THEN TBL_CUP_DELI.VAL->'out_tax_campaign_unit_price'
                        ELSE TBL_CUP_DELI.VAL->>'old_out_tax_campaign_unit_price'
                    END
                /*%end*/
                WHEN (/*# condStrInTax */ AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') AND TBL_CUP.VAL->'in_tax_campaign_unit_price' > 0)
                    OR (/*# condStrInTax */ AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') AND TBL_CUP.VAL->'old_in_tax_campaign_unit_price' > 0)
                    OR ((/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') AND TBL_CUP.VAL->'out_tax_campaign_unit_price' > 0)
                    OR ((/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') AND TBL_CUP.VAL->'old_out_tax_campaign_unit_price' > 0) THEN
                    CASE
                        WHEN /*# condStrInTax */ AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') THEN TBL_CUP.VAL->'in_tax_campaign_unit_price'
                        WHEN /*# condStrInTax */ AND IS_IN_TERM(TBL_CUP.VAL->'old_start_setting_date', TBL_CUP.VAL->'old_end_setting_date') THEN TBL_CUP.VAL->'old_in_tax_campaign_unit_price'
                        WHEN (/*# condStrNoTax */) AND IS_IN_TERM(TBL_CUP.VAL->'start_setting_date', TBL_CUP.VAL->'end_setting_date') THEN TBL_CUP.VAL->'out_tax_campaign_unit_price'
                        ELSE TBL_CUP.VAL->>'old_out_tax_campaign_unit_price'
                    END
                  /*%if userPriceAdoptDiv == "2" */
                WHEN (/*# condStrInTax */ AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'new_price_tax_included' > 0)
                    OR ((/*# condStrInTax */) AND TBL_UP_DELI.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_tax_included' > 0)
                    OR ((/*# condStrNoTax */) AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'new_price' > 0)
                    OR ((/*# condStrNoTax */) AND TBL_UP_DELI.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP_DELI.VAL->'price' > 0) THEN
                    CASE
                        WHEN /*# condStrInTax */ AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'new_price_tax_included'
                        WHEN /*# condStrInTax */ AND TBL_UP_DELI.VAL->'price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'price_tax_included'
                        WHEN (/*# condStrNoTax*/) AND TBL_UP_DELI.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP_DELI.VAL->'new_price'
                        ELSE TBL_UP_DELI.VAL->>'price'
                    END
                /*%end*/
                WHEN (/*# condStrInTax */ AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'new_price_tax_included' > 0)
                    OR ((/*# condStrInTax */) AND TBL_UP.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_tax_included' > 0)
                    OR ((/*# condStrNoTax */) AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'new_price' > 0)
                    OR ((/*# condStrNoTax */) AND TBL_UP.VAL->'new_price_date' > CAST(NOW() AS DATE) AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) AND TBL_UP.VAL->'price' > 0) THEN
                    CASE
                        WHEN /*# condStrInTax */ AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'new_price_tax_included'
                        WHEN /*# condStrInTax */ AND TBL_UP.VAL->'price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'price_tax_included'
                        WHEN (/*# condStrNoTax */) AND TBL_UP.VAL->'new_price_date' <= CAST(NOW() AS DATE) THEN TBL_UP.VAL->'new_price'
                        ELSE TBL_UP.VAL->>'price'
                    END
                ELSE
                    CASE /*# uriageTankaSaiyoDiv */
                        WHEN '0' THEN
                            CASE
                                WHEN /*# condStrInTax */ THEN BI.VAL->>'sale_unit_price_in_tax'
                                ELSE BI.VAL->>'sale_unit_price_no_tax'
                            END
                        WHEN '1' THEN
                            CASE COALESCE(TBL_UPC.VAL->'price_rank', TBL_BU.VAL->>'price_rank')
                                WHEN '1' THEN
                                    CASE
                                        WHEN /*# condStrInTax */ THEN BI.VAL->>'rank_price_6'
                                        ELSE BI.VAL->>'rank_price_1'
                                    END
                                WHEN '2' THEN
                                    CASE
                                        WHEN /*# condStrInTax */ THEN BI.VAL->>'rank_price_7'
                                        ELSE BI.VAL->>'rank_price_2'
                                    END
                                WHEN '3' THEN
                                    CASE
                                        WHEN /*# condStrInTax */ THEN BI.VAL->>'rank_price_8'
                                        ELSE BI.VAL->>'rank_price_3'
                                    END
                                WHEN '4' THEN
                                    CASE
                                        WHEN /*# condStrInTax */ THEN BI.VAL->>'rank_price_9'
                                        ELSE BI.VAL->>'rank_price_4'
                                    END
                                WHEN '5' THEN
                                    CASE
                                        WHEN /*# condStrInTax */ THEN BI.VAL->>'rank_price_10'
                                        ELSE BI.VAL->>'rank_price_5'
                                    END
                                ELSE 0
                            END
                        WHEN '2' THEN
                            (COALESCE(TBL_UPC.VAL->>'retail_price_rate', TBL_BU.VAL->>'retail_price_rate') / 100) * (CASE WHEN /*# condStrInTax */ THEN BI.VAL->>'retail_price_tax_included' ELSE BI.VAL->>'retail_price' END)
                        ELSE 0
                    END
                END
            /*%end*/
            , 0) WHOLESALE_PRICE

    --ログインユーザー用カラム
    ,CASE
        WHEN ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 1) OR
             ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 2 AND (TBL_UAC.VAL->>'cart_disp_flg')::int = 1) THEN 1
        ELSE 0
    END AS CART_DISP_FLG
FROM
    entity_data BI
    LEFT JOIN entity_data TBL_UII ON TBL_UII.tenant_id = /* tenantId */'' AND  TBL_UII.edit_table_cd = 'useriteminfo' AND BI.VAL->'item_cd' = TBL_UII.VAL->'item_cd' AND TBL_UII.VAL->>'user_cd' = /* userCd */''
    LEFT JOIN entity_data TBL_BU ON TBL_BU.tenant_id = /* tenantId */'' AND  TBL_BU.edit_table_cd = 'user' AND TBL_BU.VAL->'user_id' = TBL_UII.VAL->'user_cd'
    LEFT JOIN entity_data TBL_UAC ON TBL_UAC.tenant_id = /* tenantId */'' AND  TBL_UAC.edit_table_cd = 'useractivecartbtn' AND TBL_UAC.VAL->'user_cd' = TBL_BU.VAL->'user_cd' AND TBL_UAC.VAL->'item_cd' = BI.VAL->'item_cd'
    /*%if userPriceAdoptDiv == "2" */
        LEFT JOIN entity_data TBL_CUP_DELI ON TBL_CUP_DELI.tenant_id = /* tenantId */'' AND  TBL_CUP_DELI.edit_table_cd = 'campaignunitprice' AND BI.VAL->'item_cd' = TBL_CUP_DELI.VAL->'item_cd' AND TBL_BU.VAL->'user_cd' = TBL_CUP_DELI.VAL->'user_cd' AND TBL_CUP_DELI.VAL->'user_delivery_cd' = /* deliveryCd */''
        /*%end*/
        LEFT JOIN entity_data TBL_CUP ON TBL_CUP.tenant_id = /* tenantId */'' AND  TBL_CUP.edit_table_cd = 'campaignunitprice' AND BI.VAL->'item_cd' = TBL_CUP.VAL->'item_cd' AND TBL_BU.VAL->'user_cd' = TBL_CUP.VAL->'user_cd' AND TBL_CUP.VAL->'user_delivery_cd' = ''
        LEFT JOIN entity_data TBL_UP ON TBL_UP.tenant_id = /* tenantId */'' AND  TBL_UP.edit_table_cd = 'userprice' AND TBL_BU.VAL->'user_cd' = TBL_UP.VAL->'user_cd' AND BI.VAL->'item_cd' = TBL_UP.VAL->'item_cd' AND TBL_UP.VAL->'user_delivery_cd' = ''
    /*%if userPriceAdoptDiv == "2" */
        LEFT JOIN entity_data TBL_UP_DELI ON TBL_UP_DELI.tenant_id = /* tenantId */'' AND  TBL_UP_DELI.edit_table_cd = 'userprice' AND TBL_BU.VAL->'user_cd' = TBL_UP_DELI.VAL->'user_cd' AND BI.VAL->'item_cd' = TBL_UP_DELI.VAL->'item_cd' AND TBL_UP_DELI.VAL->'user_delivery_cd' = /* deliveryCd */''
        /*%end*/
        LEFT JOIN entity_data TBL_UPC ON TBL_UPC.tenant_id = /* tenantId */'' AND  TBL_UPC.tenant_id = /* tenantId */'' AND  TBL_UPC.edit_table_cd = 'userpricecalc' AND BI.VAL->'unit_price_category_cd' = TBL_UPC.VAL->'unit_price_category_cd' AND TBL_BU.VAL->'user_cd' = TBL_UPC.VAL->'user_cd'
WHERE
    1 = 1
AND
    BI.is_deleted = '0'
AND
    BI.tenant_id = /* tenantId */''
AND
    BI.edit_table_cd = 'item'
AND
    BI.VAL->>'item_cd' = /* itemCd */''
AND
    (BI.VAL->>'disp_flg')::int = 1
AND NOT (
    ((BI.VAL->>'user_active_item_use_flg')::int = 1)
    OR (
       (BI.VAL->>'user_active_item_use_flg')::int = 2
       AND EXISTS(
           SELECT
              1
           FROM
              entity_data BUAI
           WHERE
              BUAI.tenant_id = /* tenantId */''
           AND
              BUAI.edit_table_cd = 'useractiveitem'
           AND
              BUAI.VAL->>'user_cd'  = /* userCd */''
             AND
              BUAI.VAL->'item_cd' = BI.VAL->'item_cd'
             AND
              (BUAI.VAL->>'active_div')::int = 1
         )
   )
)
;
