SELECT
	ITEM.VAL->>'item_cd' ITEM_CD,
	ITEM.VAL->>'item_name1' ITEM_NAME1,
	ITEM.VAL->>'item_name2' ITEM_NAME2,
	ITEM.VAL->>'item_name_kana' ITEM_NAME_KANA,
	ITEM.VAL->>'tax_exempt_div' TAX_EXEMPT_DIV,
	ITEM.VAL->>'tax_bracket_cd' TAX_BRACKET_CD,
	ITEM.VAL->>'quantity_per_case' QUANTITY_PER_CASE,
	COALESCE(ITEM.VAL->>'unit', '') UNIT,
	COALESCE(UI.VAL->>'user_item_cd', '') USER_ITEM_CD,
	COALESCE(UI.VAL->>'user_item_name1', '') USER_ITEM_NAME1,
	COALESCE(UI.VAL->>'user_item_name2', '') USER_ITEM_NAME2
FROM
	entity_data ITEM
	LEFT JOIN entity_data UI ON UI.tenant_id = /* tenantId */'' AND UI.edit_table_cd = 'useriteminfo' AND ITEM.VAL->'item_cd' = UI.VAL->'item_cd' AND UI.VAL->>'user_cd' = /* userCd */''
WHERE
    ITEM.is_deleted = '0'
    AND ITEM.tenant_id = /* tenantId */''
	AND ITEM.edit_table_cd = 'item'
	AND ITEM.VAL->>'item_cd' = /* itemCd */''
;