SELECT
    count(*) OVER() as count,
    BI.VAL->>'item_id' ITEM_ID,
    BI.VAL->>'item_cd' ITEM_CD,
    BI.VAL->>'item_name1' ITEM_NAME1,
    BI.VAL->>'item_name2' ITEM_NAME2,
    COALESCE(BI.VAL->>'item_name1','') || COALESCE(BI.VAL->>'item_name2','') ITEM_NAME,
    BI.VAL->>'unit' UNIT,
    BI.VAL->>'sale_unit_price_no_tax' SALE_UNIT_PRICE_NO_TAX,
    BI.VAL->>'sale_unit_price_in_tax' SALE_UNIT_PRICE_IN_TAX,
    BI.VAL->>'retail_price' RETAIL_PRICE,
    BI.VAL->>'retail_price_tax_included' RETAIL_PRICE_TAX_INCLUDED,
    BI.VAL->>'item_category_cd_1' ITEM_CATEGORY_CD_1,
    BI.VAL->>'item_category_cd_2' ITEM_CATEGORY_CD_2,
    BI.VAL->>'item_category_cd_3' ITEM_CATEGORY_CD_3,
    BI.VAL->>'item_category_cd_4' ITEM_CATEGORY_CD_4,
    BI.VAL->>'item_category_cd_5' ITEM_CATEGORY_CD_5,
    BI.VAL->>'item_category_cd_6' ITEM_CATEGORY_CD_6,
    BI.VAL->>'item_category_cd_7' ITEM_CATEGORY_CD_7,
    BI.VAL->>'item_category_cd_8' ITEM_CATEGORY_CD_8,
    BI.VAL->>'item_category_cd_9' ITEM_CATEGORY_CD_9,
    BI.VAL->>'item_category_cd_10' ITEM_CATEGORY_CD_10,
    BI.VAL->>'item_image1' ITEM_IMAGE1,
    BI.VAL->>'item_image2' ITEM_IMAGE2,
    BI.VAL->>'item_image3' ITEM_IMAGE3,
    BI.VAL->>'item_image4' ITEM_IMAGE4,
    BI.VAL->>'item_image5' ITEM_IMAGE5,
    BI.VAL->>'remarks1' REMARKS1,
    BI.VAL->>'remarks2' REMARKS2,
    BI.VAL->>'remarks3' REMARKS3,
    BI.VAL->>'stock_div' STOCK_DIV,
    BI.VAL->>'jan_cd' JAN_CD,
    BI.VAL->>'web_remarks1' WEB_REMARKS1,
    BI.VAL->>'web_remarks2' WEB_REMARKS2,
    BI.VAL->>'quantity_per_case' QUANTITY_PER_CASE,

    --暫定
    BI.VAL->>'sale_unit_price_no_tax' WHOLE_SALE_PRICE,

    --ログインユーザー用カラム
    CASE
        WHEN ((BI.VAL->>'disp_flg')::int = 1 AND (BI.VAL->>'user_active_item_use_flg')::int = 1) OR
             ((BI.VAL->>'disp_flg')::int = 1 AND (BI.VAL->>'user_active_item_use_flg')::int = 2 AND (TBL_UAI.VAL->>'active_div')::int = 1) THEN 1
        ELSE 0
    END AS ITEM_DISP_FLG,
    CASE
        WHEN ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 1) OR
             ((BI.VAL->>'cart_disp_flg')::int = 1 AND (BI.VAL->>'user_cartbt_disp_use_flg')::int = 2 AND (TBL_UAC.VAL->>'cart_disp_flg')::int = 1) THEN 1
        ELSE 0
    END AS CART_DISP_FLG

FROM
    entity_data BI
    LEFT JOIN entity_data TBL_UII ON TBL_UII.tenant_id = /* tenantId */'' AND  TBL_UII.edit_table_cd = 'useriteminfo' AND BI.VAL->>'item_cd' = TBL_UII.VAL->>'item_cd' AND TBL_UII.VAL->>'user_cd' = /* userCd */''
    LEFT JOIN entity_data TBL_BU ON TBL_BU.tenant_id = /* tenantId */'' AND  TBL_BU.edit_table_cd = 'user' AND TBL_BU.VAL->'user_cd' = TBL_UII.VAL->'user_cd'
    LEFT JOIN entity_data TBL_UAI ON TBL_UAI.tenant_id = /* tenantId */'' AND  TBL_UAI.edit_table_cd = 'useractiveitem' AND TBL_UAI.VAL->'user_cd' = TBL_BU.VAL->'user_cd' AND TBL_UAI.VAL->'item_cd' = BI.VAL->'item_cd'
    LEFT JOIN entity_data TBL_UAC ON TBL_UAC.tenant_id = /* tenantId */'' AND  TBL_UAC.edit_table_cd = 'useractivecartbtn' AND TBL_UAC.VAL->'user_cd' = TBL_BU.VAL->'user_cd' AND TBL_UAC.VAL->'item_cd' = BI.VAL->'item_cd'
WHERE
    1 = 1
AND
    BI.is_deleted = '0'
AND
    BI.tenant_id = /* tenantId */''
AND
    BI.edit_table_cd = 'item'
AND
    BI.VAL->>'item_cd' = /* itemCd */''
AND
    (BI.VAL->>'disp_flg')::int = 1
;
