SELECT
	BIC.val->>'id' AS id,
	BIC.val->>'name1' AS name1,
	BIC.val->>'name2' AS name2,
	BIC.val->>'note' AS note,
	BIC.val->>'admin_change_div' AS admin_change_div,
	(CASE BIC.val->>'name1'
		WHEN '全般' THEN 1
		WHEN '管理サイト全般' THEN 2
		WHEN 'システム管理者設定' THEN 3
		WHEN '管理者パスワード変更' THEN 4
		WHEN 'カート' THEN 5
		WHEN '既存' THEN 98
		WHEN 'データアップロード' THEN 99
		ELSE 50
	END) AS message_group
FROM
	entity_data BIC
WHERE
	1 = 1
AND
    BIC.is_deleted = '0'
AND
	BIC.tenant_id = /* tenantId */'1'
AND
	BIC.edit_table_cd = 'message'
AND
	BIC.val->>'admin_change_div' = '1'
ORDER BY
	message_group,
	BIC.val->>'name1' ASC,
	BIC.val->>'name2' ASC
;
