SELECT
    CART.VAL->>'cart_id' CART_ID,
    CART.VAL->>'item_cd' ITEM_CD,
    CART.VAL->>'retail_price' RETAIL_PRICE,
    CART.VAL->>'wholesale_price' WHOLESALE_PRICE,
    CART.VAL->>'order_quantity' ORDER_QUANTITY,
    CART.VAL->>'order_case_quantity' ORDER_CASE_QUANTITY,
    CART.VAL->>'user_cd' USER_CD,
    CART.VAL->>'user_charge_id' USER_CHARGE_ID
FROM
    entity_data CART
WHERE
    CART.is_deleted = '0'
    AND CART.tenant_id = /* tenantId */''
    AND CART.edit_table_cd = 'cart'
    AND CART.VAL->>'item_cd' = /* itemCd */''
    AND CART.VAL->>'user_cd'= /* userCd */''
    AND CART.VAL->>'user_charge_id' = /* userChargeId */''
    AND 0 /*%if caseFlg */ <> /*%else*/ = /*%end*/ (COALESCE(CASE WHEN CART.VAL->>'order_case_quantity' = '' THEN NULL ELSE CART.VAL->>'order_case_quantity' END, '0'))::decimal

;