/*
 * Copyright 2009-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.orangesignal.csv.filters;

import java.io.IOException;

/**
 * 指定された Java プログラム要素のフィールド値が判定基準値群のいずれとも等しくないかどうかでフィルタを適用する Java プログラム要素フィルタの実装です。
 * 
 * @author Koji Sugisawa
 * @since 1.2.3
 */
public class BeanNotInExpression extends BeanCriteriasExpression {

	/**
	 * コンストラクタです。
	 * 
	 * @param name フィールド名
	 * @param criterias 判定基準値群
	 * @throws IllegalArgumentException パラメータが <code>null</code> の場合
	 */
	protected BeanNotInExpression(final String name, final Object... criterias) {
		super(name, criterias);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param name フィールド名
	 * @param criterias 判定基準値群
	 * @throws IllegalArgumentException パラメータが <code>null</code> の場合
	 */
	protected BeanNotInExpression(final String name, final String... criterias) {
		super(name, criterias);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param name フィールド名
	 * @param criterias 判定基準値群
	 * @param ignoreCase 大文字と小文字を区別するかどうか
	 * @throws IllegalArgumentException パラメータが <code>null</code> の場合
	 */
	protected BeanNotInExpression(final String name, final String[] criterias, final boolean ignoreCase) {
		super(name, criterias, ignoreCase);
	}

	@Override
	public boolean accept(final Object bean) throws IOException {
		return BeanExpressionUtils.notIn(bean, name, criterias, ignoreCase);
	}

}
